/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.utils;

import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface TryConsumer<T, Ex extends Throwable>
extends Consumer<T> {
    public static final Logger log = LoggerFactory.getLogger(TryConsumer.class);

    public void tryAccept(T var1) throws Ex;

    @Override
    default public void accept(T t) {
        try {
            this.tryAccept(t);
        }
        catch (Throwable ex) {
            log.error(ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
    }

    public static <T, Ex extends Throwable> Consumer<T> Try(TryConsumer<T, Ex> consumer) {
        return consumer;
    }
}

