/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bsc.langgraph4j.StateGraph;

public class EdgeMappings {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, String> mappings = new LinkedHashMap<String, String>();

        public Builder toEND() {
            this.mappings.put(StateGraph.END, StateGraph.END);
            return this;
        }

        public Builder toEND(String label) {
            this.mappings.put(label, StateGraph.END);
            return this;
        }

        public Builder to(String destination) {
            this.mappings.put(destination, destination);
            return this;
        }

        public Builder to(String destination, String label) {
            this.mappings.put(label, destination);
            return this;
        }

        public Builder to(List<String> destinations) {
            destinations.forEach(this::to);
            return this;
        }

        public Builder to(String[] destinations) {
            return this.to(Arrays.asList(destinations));
        }

        public Map<String, String> build() {
            return Collections.unmodifiableMap(this.mappings);
        }
    }
}

