/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.utils;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class CollectionsUtils {
    public static String toString(Collection<?> collection) {
        if (collection.isEmpty()) {
            return "[]";
        }
        return collection.stream().map(Objects::toString).collect(Collectors.joining("\n\t", "[\n\t", "\n\t]"));
    }

    public static String toString(Map<?, ?> map) {
        if (map.isEmpty()) {
            return "{}";
        }
        return map.entrySet().stream().map(entry -> {
            Object patt874$temp = entry.getValue();
            if (patt874$temp instanceof Collection) {
                Collection elements = (Collection)patt874$temp;
                return String.format("%s=%s", entry.getKey(), CollectionsUtils.toString(elements));
            }
            return Objects.toString(entry);
        }).collect(Collectors.joining("\n\t", "{\n\t", "\n\t}"));
    }

    @Deprecated(forRemoval=true)
    public static <T> Optional<T> last(List<T> values) {
        return CollectionsUtils.lastOf(values);
    }

    public static <T> Optional<T> lastOf(List<T> values) {
        return values == null || values.isEmpty() ? Optional.empty() : Optional.of(values.get(values.size() - 1));
    }

    public static <T> Optional<T> lastMinus(List<T> values, int n) {
        if (n < 0 || values == null || values.isEmpty()) {
            return Optional.empty();
        }
        int index = values.size() - n - 1;
        return index < 0 ? Optional.empty() : Optional.of(values.get(index));
    }

    public static <K, V> Map<K, V> mergeMap(Map<K, V> map1, Map<K, V> map2) {
        Stream map1Entries = Objects.requireNonNull(map1, "map1 cannot be null").entrySet().stream();
        Stream map2Entries = Objects.requireNonNull(map2, "map2 cannot be null").entrySet().stream();
        return Stream.concat(map1Entries, map2Entries).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static <K, V> Map<K, V> mergeMap(Map<K, V> map1, Map<K, V> map2, BinaryOperator<V> mergeFunction) {
        Stream map1Entries = Objects.requireNonNull(map1, "map1 cannot be null").entrySet().stream();
        Stream map2Entries = Objects.requireNonNull(map2, "map2 cannot be null").entrySet().stream();
        Objects.requireNonNull(mergeFunction, "mergeFunction cannot be null");
        return Stream.concat(map1Entries, map2Entries).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, mergeFunction));
    }

    public static <K, V> Map.Entry<K, V> entryOf(K key, V value) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
    }

    @Deprecated
    public static <T> List<T> listOf(Class<T> clazz) {
        return Collections.emptyList();
    }

    @SafeVarargs
    public static <T> List<T> listOf(T ... objects) {
        if (objects == null) {
            return Collections.emptyList();
        }
        if (objects.length == 0) {
            return Collections.emptyList();
        }
        if (objects.length == 1) {
            return Collections.singletonList(objects[0]);
        }
        return Collections.unmodifiableList(Arrays.asList(objects));
    }

    public static <K, V> Map<K, V> mapOf() {
        return Collections.emptyMap();
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1) {
        return Collections.singletonMap(k1, v1);
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2) {
        HashMap<K, V> result = new HashMap<K, V>();
        result.put(k1, v1);
        result.put(k2, v2);
        return Collections.unmodifiableMap(result);
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2, K k3, V v3) {
        HashMap<K, V> result = new HashMap<K, V>();
        result.put(k1, v1);
        result.put(k2, v2);
        result.put(k3, v3);
        return Collections.unmodifiableMap(result);
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        HashMap<K, V> result = new HashMap<K, V>();
        result.put(k1, v1);
        result.put(k2, v2);
        result.put(k3, v3);
        result.put(k4, v4);
        return Collections.unmodifiableMap(result);
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        HashMap<K, V> result = new HashMap<K, V>();
        result.put(k1, v1);
        result.put(k2, v2);
        result.put(k3, v3);
        result.put(k4, v4);
        result.put(k5, v5);
        return Collections.unmodifiableMap(result);
    }
}

