/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.state;

import java.util.Optional;
import java.util.function.Supplier;
import org.bsc.langgraph4j.state.AgentState;
import org.bsc.langgraph4j.state.Reducer;

public interface Channel<T> {
    public Optional<Reducer<T>> getReducer();

    public Optional<Supplier<T>> getDefault();

    default public boolean isMarkedForReset(Object value) {
        return value == null || value == AgentState.MARK_FOR_RESET;
    }

    default public boolean isMarkedForRemoval(Object value) {
        return value == AgentState.MARK_FOR_REMOVAL;
    }

    default public Object update(String key, Object oldValue, Object newValue) {
        if (this.isMarkedForReset(newValue)) {
            return this.getDefault().orElse(() -> null).get();
        }
        if (this.isMarkedForRemoval(newValue)) {
            return null;
        }
        Object _new = newValue;
        Object _old = oldValue == null ? this.getDefault().map(Supplier::get).orElse(null) : oldValue;
        return this.getReducer().map(reducer -> reducer.apply(_old, _new)).orElse(_new);
    }
}

