/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.state;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.bsc.langgraph4j.state.Channel;
import org.bsc.langgraph4j.state.Reducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppenderChannel<T>
implements Channel<List<T>> {
    private static final Logger log = LoggerFactory.getLogger(AppenderChannel.class);
    private final Reducer<List<T>> reducer;
    private final Supplier<List<T>> defaultProvider;

    @Override
    public Optional<Reducer<List<T>>> getReducer() {
        return Optional.ofNullable(this.reducer);
    }

    @Override
    public Optional<Supplier<List<T>>> getDefault() {
        return Optional.ofNullable(this.defaultProvider);
    }

    protected AppenderChannel(Reducer<List<T>> reducer, Supplier<List<T>> defaultProvider) {
        this.reducer = reducer;
        this.defaultProvider = defaultProvider;
    }

    private List<T> remove(List<T> list, RemoveIdentifier<T> removeIdentifier) {
        ArrayList<T> result = new ArrayList<T>(list);
        this.removeFromList(result, removeIdentifier);
        return Collections.unmodifiableList(result);
    }

    private void removeFromList(List<T> result, RemoveIdentifier<T> removeIdentifier) {
        Iterator<T> iterator = result.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            T element = iterator.next();
            if (removeIdentifier.compareTo(element, index++) != 0) continue;
            iterator.remove();
        }
    }

    private RemoveData<T> evaluateRemoval(List<T> oldValues, List<?> newValues) {
        RemoveData<T> result = new RemoveData<T>(oldValues, newValues);
        newValues.stream().filter(value -> value instanceof RemoveIdentifier).forEach(value -> {
            result.newValues().remove(value);
            RemoveIdentifier removeIdentifier = (RemoveIdentifier)value;
            this.removeFromList(result.oldValues(), removeIdentifier);
        });
        return result;
    }

    protected List<T> validateNewValues(List<?> list) {
        return list;
    }

    @Override
    public final Object update(String key, Object oldValue, Object newValue) {
        if (this.isMarkedForReset(newValue)) {
            return this.getDefault().orElse(ArrayList::new).get();
        }
        if (this.isMarkedForRemoval(newValue)) {
            return null;
        }
        boolean oldValueIsList = oldValue instanceof List;
        try {
            if (oldValueIsList && newValue instanceof RemoveIdentifier) {
                return this.remove((List)oldValue, (RemoveIdentifier)newValue);
            }
            List<Object> list = null;
            list = newValue instanceof List ? (List<Object>)newValue : (newValue.getClass().isArray() ? Arrays.asList((Object[])newValue) : List.of(newValue));
            if (list.isEmpty()) {
                return oldValue;
            }
            List<T> typedList = this.validateNewValues(list);
            if (oldValueIsList) {
                RemoveData<T> result = this.evaluateRemoval((List)oldValue, typedList);
                return Channel.super.update(key, result.oldValues(), result.newValues());
            }
            return Channel.super.update(key, oldValue, typedList);
        }
        catch (UnsupportedOperationException ex) {
            log.error("Unsupported operation: probably because the appendable channel has been initialized with a immutable List. Check please !");
            throw ex;
        }
    }

    @FunctionalInterface
    public static interface RemoveIdentifier<T> {
        public int compareTo(T var1, int var2);
    }

    record RemoveData<T>(List<T> oldValues, List<?> newValues) {
        public RemoveData {
            oldValues = new ArrayList<T>(oldValues);
            newValues = new ArrayList(newValues);
        }
    }

    public static class ReducerAllowDuplicate<T>
    implements Reducer<List<T>> {
        @Override
        public List<T> apply(List<T> left, List<T> right) {
            if (left == null) {
                return right;
            }
            left.addAll(right);
            return left;
        }
    }

    public static class ReducerDisallowDuplicate<T>
    implements Reducer<List<T>> {
        @Override
        public List<T> apply(List<T> left, List<T> right) {
            if (left == null) {
                return right;
            }
            for (Object rValue : right) {
                if (!left.stream().noneMatch(lValue -> Objects.hash(lValue) == Objects.hash(rValue))) continue;
                left.add(rValue);
            }
            return left;
        }
    }
}

