/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.bsc.langgraph4j.state.Channel;
import org.bsc.langgraph4j.utils.CollectionsUtils;

public class AgentState {
    public static final Object MARK_FOR_RESET = new Object();
    public static final Object MARK_FOR_REMOVAL = new Object();
    private final Map<String, Object> data;

    public AgentState(Map<String, Object> initData) {
        this.data = new HashMap<String, Object>(initData);
    }

    public final Map<String, Object> data() {
        return Collections.unmodifiableMap(this.data);
    }

    public final <T> Optional<T> value(String key) {
        return Optional.ofNullable(this.data().get(key));
    }

    public String toString() {
        return CollectionsUtils.toString(this.data);
    }

    private static Collector<Map.Entry<String, Object>, ?, Map<String, Object>> toMapRemovingItemMarkedForRemoval() {
        BinaryOperator mergeFunction = (currentValue, newValue) -> newValue;
        return Collector.of(HashMap::new, (map, element) -> {
            String key = (String)element.getKey();
            Object value = element.getValue();
            if (value == null || value == MARK_FOR_RESET || value == MARK_FOR_REMOVAL) {
                map.remove(key);
            } else {
                map.merge(key, value, mergeFunction);
            }
        }, (map1, map2) -> {
            map2.forEach((key, value) -> {
                if (value != null && value != MARK_FOR_RESET && value != MARK_FOR_REMOVAL) {
                    map1.merge(key, value, mergeFunction);
                }
            });
            return map1;
        }, Collector.Characteristics.UNORDERED);
    }

    private static Collector<Map.Entry<String, Object>, ?, Map<String, Object>> toMapAllowingNulls() {
        return Collector.of(HashMap::new, (map, element) -> map.put((String)element.getKey(), element.getValue()), (map1, map2) -> {
            map1.putAll(map2);
            return map1;
        }, Collector.Characteristics.UNORDERED);
    }

    private static Map<String, Object> updatePartialStateFromSchema(Map<String, Object> state, Map<String, Object> partialState, Map<String, Channel<?>> channels) {
        if (channels == null || channels.isEmpty()) {
            return partialState;
        }
        return partialState.entrySet().stream().map(entry -> {
            Channel channel = (Channel)channels.get(entry.getKey());
            if (channel != null) {
                Object newValue = channel.update((String)entry.getKey(), state.get(entry.getKey()), entry.getValue());
                return CollectionsUtils.entryOf((String)entry.getKey(), newValue);
            }
            return entry;
        }).collect(AgentState.toMapAllowingNulls());
    }

    public static Map<String, Object> updateState(Map<String, Object> state, Map<String, Object> partialState, Map<String, Channel<?>> channels) {
        Objects.requireNonNull(state, "state cannot be null");
        if (partialState == null || partialState.isEmpty()) {
            return state;
        }
        Map<String, Object> updatedPartialState = AgentState.updatePartialStateFromSchema(state, partialState, channels);
        return Stream.concat(state.entrySet().stream(), updatedPartialState.entrySet().stream()).collect(AgentState.toMapRemovingItemMarkedForRemoval());
    }

    public static Map<String, Object> updateState(AgentState state, Map<String, Object> partialState, Map<String, Channel<?>> channels) {
        return AgentState.updateState(state.data(), partialState, channels);
    }

    @Deprecated
    public final <T> T value(String key, T defaultValue) {
        return this.value(key).orElse(defaultValue);
    }

    @Deprecated
    public final <T> T value(String key, Supplier<T> defaultProvider) {
        return this.value(key).orElseGet(defaultProvider);
    }

    @Deprecated
    public final Map<String, Object> mergeWith(Map<String, Object> partialState, Map<String, Channel<?>> channels) {
        return AgentState.updateState(this.data(), partialState, channels);
    }
}

