/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.serializer.std;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bsc.langgraph4j.serializer.Serializer;
import org.bsc.langgraph4j.serializer.std.ObjectInputWithMapper;
import org.bsc.langgraph4j.serializer.std.ObjectOutputWithMapper;

public class SerializerMapper {
    static final Serializer<Object> DEFAULT_SERIALIZER = new Serializer<Object>(){

        @Override
        public void write(Object object, ObjectOutput out) throws IOException {
            out.writeObject(object);
        }

        @Override
        public Object read(ObjectInput in) throws IOException, ClassNotFoundException {
            return in.readObject();
        }
    };
    private final Map<Key, Serializer<?>> _serializers = new HashMap();

    public SerializerMapper register(Class<?> clazz, Serializer<?> serializer) {
        Objects.requireNonNull(clazz, "class cannot be null ");
        Objects.requireNonNull(clazz, "serializer cannot be null ");
        this._serializers.put(Key.of(clazz), serializer);
        return this;
    }

    public boolean unregister(Class<? extends Serializer<?>> clazz) {
        Objects.requireNonNull(clazz, "Serializer's class cannot be null");
        Serializer<?> serializer = this._serializers.remove(Key.of(clazz));
        return serializer != null;
    }

    public Optional<Serializer<Object>> getSerializer(Class<?> clazz) {
        Objects.requireNonNull(clazz, "class cannot be null ");
        Serializer<?> ser = this._serializers.get(Key.of(clazz));
        return ser != null ? Optional.of(ser) : this._serializers.entrySet().stream().filter(e -> ((Key)e.getKey()).getType().isAssignableFrom(clazz)).findFirst().map(e -> (Serializer)e.getValue());
    }

    public Optional<Serializer<Object>> getSerializer(String className) {
        Objects.requireNonNull(className, "className cannot be null ");
        return Optional.ofNullable(this._serializers.get(Key.of(className)));
    }

    public Serializer<Object> getDefaultSerializer() {
        return DEFAULT_SERIALIZER;
    }

    protected final ObjectOutput objectOutputWithMapper(ObjectOutput out) {
        Objects.requireNonNull(out, "ObjectOutput cannot be null");
        ObjectOutputWithMapper mapperOut = out instanceof ObjectOutputWithMapper ? (ObjectOutputWithMapper)out : new ObjectOutputWithMapper(out, this);
        return mapperOut;
    }

    protected final ObjectInput objectInputWithMapper(ObjectInput in) {
        Objects.requireNonNull(in, "ObjectInput cannot be null");
        ObjectInputWithMapper mapperIn = in instanceof ObjectInputWithMapper ? (ObjectInputWithMapper)in : new ObjectInputWithMapper(in, this);
        return mapperIn;
    }

    public String toString() {
        List typeNames = this._serializers.keySet().stream().map(Key::getTypeName).collect(Collectors.toList());
        return String.format("SerializerMapper: \n%s", String.join((CharSequence)"\n", typeNames));
    }

    static class Key {
        private final String _className;
        private final Class<?> _clazz;

        public static Key of(Class<?> clazz) {
            return new Key(clazz);
        }

        public static Key of(String className) {
            return new Key(className);
        }

        private Key(Class<?> clazz) {
            this._className = clazz.getName();
            this._clazz = clazz;
        }

        private Key(String className) {
            this._className = className;
            this._clazz = null;
        }

        String getTypeName() {
            return this._className;
        }

        Class<?> getType() {
            return this._clazz;
        }

        public boolean equals(Object o) {
            return Objects.equals(o, this._className);
        }

        public int hashCode() {
            return Objects.hash(this._className);
        }
    }
}

