/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.serializer.std;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bsc.langgraph4j.serializer.StateSerializer;
import org.bsc.langgraph4j.serializer.std.NullableObjectSerializer;
import org.bsc.langgraph4j.serializer.std.SerializerMapper;
import org.bsc.langgraph4j.state.AgentState;
import org.bsc.langgraph4j.state.AgentStateFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStreamStateSerializer<State extends AgentState>
extends StateSerializer<State> {
    private static final Logger log = LoggerFactory.getLogger(ObjectStreamStateSerializer.class);
    private final SerializerMapper mapper = new SerializerMapper();
    private final MapSerializer mapSerializer = new MapSerializer();

    public ObjectStreamStateSerializer(AgentStateFactory<State> stateFactory) {
        super(stateFactory);
        this.mapper.register(Collection.class, new ListSerializer());
        this.mapper.register(Map.class, new MapSerializer());
    }

    public SerializerMapper mapper() {
        return this.mapper;
    }

    @Override
    public final void writeData(Map<String, Object> data, ObjectOutput out) throws IOException {
        this.mapSerializer.write(data, this.mapper.objectOutputWithMapper(out));
    }

    @Override
    public final Map<String, Object> readData(ObjectInput in) throws IOException, ClassNotFoundException {
        return this.mapSerializer.read(this.mapper.objectInputWithMapper(in));
    }

    static class MapSerializer
    implements NullableObjectSerializer<Map<String, Object>> {
        MapSerializer() {
        }

        @Override
        public void write(Map<String, Object> object, ObjectOutput out) throws IOException {
            out.writeInt(object.size());
            for (Map.Entry<String, Object> e : object.entrySet()) {
                try {
                    out.writeUTF(e.getKey());
                    this.writeNullableObject(e.getValue(), out);
                }
                catch (IOException ex) {
                    log.error("Error writing map key '{}'", (Object)e.getKey(), (Object)ex);
                    throw ex;
                }
            }
            out.flush();
        }

        @Override
        public Map<String, Object> read(ObjectInput in) throws IOException, ClassNotFoundException {
            HashMap<String, Object> result = new HashMap<String, Object>();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                String key = in.readUTF();
                Object value = this.readNullableObject(in).orElse(null);
                result.put(key, value);
            }
            return result;
        }
    }

    static class ListSerializer
    implements NullableObjectSerializer<List<Object>> {
        ListSerializer() {
        }

        @Override
        public void write(List<Object> object, ObjectOutput out) throws IOException {
            out.writeInt(object.size());
            for (Object value : object) {
                try {
                    this.writeNullableObject(value, out);
                }
                catch (IOException ex) {
                    log.error("Error writing collection value", (Throwable)ex);
                    throw ex;
                }
            }
            out.flush();
        }

        @Override
        public List<Object> read(ObjectInput in) throws IOException, ClassNotFoundException {
            ArrayList<Object> result = new ArrayList<Object>();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                Object value = this.readNullableObject(in).orElse(null);
                result.add(value);
            }
            return result;
        }
    }
}

