/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.serializer.std;

import java.io.IOException;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.Optional;
import org.bsc.langgraph4j.serializer.Serializer;
import org.bsc.langgraph4j.serializer.std.SerializerMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ObjectOutputWithMapper
implements ObjectOutput {
    private static final Logger log = LoggerFactory.getLogger(ObjectOutputWithMapper.class);
    private final ObjectOutput out;
    private final SerializerMapper mapper;

    public ObjectOutputWithMapper(ObjectOutput out, SerializerMapper mapper) {
        this.out = Objects.requireNonNull(out, "out cannot be null");
        this.mapper = Objects.requireNonNull(mapper, "mapper cannot be null");
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        Objects.requireNonNull(obj, "object to serialize cannot be null");
        Optional<Serializer<Object>> serializer = this.mapper.getSerializer(obj.getClass());
        if (serializer.isPresent()) {
            this.out.writeObject(obj.getClass());
            serializer.get().write(obj, this);
        } else {
            this.out.writeObject(obj);
        }
        this.out.flush();
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.out.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.out.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.out.writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.out.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.out.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.out.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.out.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.out.writeDouble(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.out.writeBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.out.writeChars(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.out.writeUTF(s);
    }
}

