/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.serializer.plain_text.jackson;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class TypeMapper {
    public static String TYPE_PROPERTY = "@type";
    private final Set<Reference<?>> references = new HashSet();

    public <T> TypeMapper register(Reference<T> reference) {
        Objects.requireNonNull(reference, "reference cannot be null");
        this.references.add(reference);
        return this;
    }

    public <T> boolean unregister(Reference<T> reference) {
        Objects.requireNonNull(reference, "reference cannot be null");
        return this.references.remove(reference);
    }

    public Optional<Reference<?>> getReference(String type) {
        Objects.requireNonNull(type, "type cannot be null");
        return this.references.stream().filter(ref -> Objects.equals(ref.getTypeName(), type)).findFirst();
    }

    public static abstract class Reference<T>
    extends TypeReference<T> {
        private final String typeName;

        public Reference(String typeName) {
            this.typeName = Objects.requireNonNull(typeName, "typeName cannot be null");
        }

        public String getTypeName() {
            return this.typeName;
        }
    }
}

