/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.serializer.plain_text.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bsc.langgraph4j.serializer.plain_text.PlainTextStateSerializer;
import org.bsc.langgraph4j.serializer.plain_text.jackson.GenericListDeserializer;
import org.bsc.langgraph4j.serializer.plain_text.jackson.GenericMapDeserializer;
import org.bsc.langgraph4j.serializer.plain_text.jackson.TypeMapper;
import org.bsc.langgraph4j.state.AgentState;
import org.bsc.langgraph4j.state.AgentStateFactory;

public abstract class JacksonStateSerializer<State extends AgentState>
extends PlainTextStateSerializer<State> {
    protected final ObjectMapper objectMapper;
    protected TypeMapper typeMapper = new TypeMapper();

    protected JacksonStateSerializer(AgentStateFactory<State> stateFactory) {
        this(stateFactory, new ObjectMapper());
        this.objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    }

    protected JacksonStateSerializer(AgentStateFactory<State> stateFactory, ObjectMapper objectMapper) {
        super(stateFactory);
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper cannot be null");
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Map.class, (JsonDeserializer)new GenericMapDeserializer(this.typeMapper));
        module.addDeserializer(List.class, (JsonDeserializer)new GenericListDeserializer(this.typeMapper));
        this.objectMapper.registerModule((Module)module);
    }

    public TypeMapper typeMapper() {
        return this.typeMapper;
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    @Override
    public String contentType() {
        return "application/json";
    }

    @Override
    public final void writeData(Map<String, Object> data, ObjectOutput out) throws IOException {
        String json = this.objectMapper.writeValueAsString(data);
        out.writeObject(json);
    }

    @Override
    public final Map<String, Object> readData(ObjectInput in) throws IOException, ClassNotFoundException {
        String json = Objects.toString(in.readObject());
        return (Map)this.objectMapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }
}

