/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.serializer.plain_text.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bsc.langgraph4j.serializer.plain_text.jackson.TypeMapper;

class GenericMapDeserializer
extends StdDeserializer<Map<String, Object>> {
    final TypeMapper typeMapper;

    public GenericMapDeserializer(TypeMapper mapper) {
        super(Map.class);
        this.typeMapper = mapper;
    }

    public Map<String, Object> deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
        ObjectMapper mapper = (ObjectMapper)p.getCodec();
        ObjectNode node = (ObjectNode)mapper.readTree(p);
        HashMap<String, Object> result = new HashMap<String, Object>();
        Iterator fields = node.fields();
        while (fields.hasNext()) {
            Object value;
            Map.Entry entry = (Map.Entry)fields.next();
            String key = (String)entry.getKey();
            JsonNode valueNode = (JsonNode)entry.getValue();
            if (valueNode.isObject()) {
                if (valueNode.has(TypeMapper.TYPE_PROPERTY)) {
                    String type = valueNode.get(TypeMapper.TYPE_PROPERTY).asText();
                    TypeMapper.Reference<?> ref = this.typeMapper.getReference(type).orElseThrow(() -> new IllegalStateException("Type not found: " + type));
                    value = mapper.treeToValue((TreeNode)valueNode, ref);
                } else {
                    value = mapper.treeToValue((TreeNode)valueNode, Object.class);
                }
            } else if (valueNode.isInt()) {
                value = valueNode.intValue();
            } else if (valueNode.isTextual()) {
                value = valueNode.textValue();
            } else if (valueNode.isBoolean()) {
                value = valueNode.booleanValue();
            } else if (valueNode.isArray()) {
                value = mapper.treeToValue((TreeNode)valueNode, List.class);
            } else {
                throw new IllegalStateException("Value type not supported: " + String.valueOf(valueNode.getNodeType()));
            }
            result.put(key, value);
        }
        return result;
    }
}

