/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.serializer.plain_text.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.bsc.langgraph4j.serializer.plain_text.jackson.TypeMapper;

class GenericListDeserializer
extends StdDeserializer<List<Object>> {
    final TypeMapper typeMapper;

    public GenericListDeserializer(TypeMapper typeMapper) {
        super(List.class);
        this.typeMapper = Objects.requireNonNull(typeMapper, "typeMapper cannot be null");
    }

    public List<Object> deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
        ObjectMapper mapper = (ObjectMapper)p.getCodec();
        ArrayNode node = (ArrayNode)mapper.readTree(p);
        LinkedList<Object> result = new LinkedList<Object>();
        for (JsonNode valueNode : node) {
            Object value;
            if (valueNode.isObject()) {
                if (valueNode.has(TypeMapper.TYPE_PROPERTY)) {
                    String type = valueNode.get(TypeMapper.TYPE_PROPERTY).asText();
                    TypeMapper.Reference<?> ref = this.typeMapper.getReference(type).orElseThrow(() -> new IllegalStateException("Type not found: " + type));
                    value = mapper.treeToValue((TreeNode)valueNode, ref);
                } else {
                    value = mapper.treeToValue((TreeNode)valueNode, Object.class);
                }
            } else if (valueNode.isInt()) {
                value = valueNode.intValue();
            } else if (valueNode.isTextual()) {
                value = valueNode.textValue();
            } else if (valueNode.isBoolean()) {
                value = valueNode.booleanValue();
            } else if (valueNode.isArray()) {
                value = mapper.treeToValue((TreeNode)valueNode, List.class);
            } else {
                throw new IllegalStateException("Value type not supported: " + String.valueOf(valueNode.getNodeType()));
            }
            result.add(value);
        }
        return result;
    }
}

