/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.serializer.plain_text.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.bsc.langgraph4j.serializer.plain_text.PlainTextStateSerializer;
import org.bsc.langgraph4j.state.AgentState;
import org.bsc.langgraph4j.state.AgentStateFactory;

public abstract class GsonStateSerializer<State extends AgentState>
extends PlainTextStateSerializer<State> {
    protected final Gson gson;

    protected GsonStateSerializer(AgentStateFactory<State> stateFactory, Gson gson) {
        super(stateFactory);
        this.gson = gson;
    }

    protected GsonStateSerializer(AgentStateFactory<State> stateFactory) {
        this(stateFactory, new GsonBuilder().serializeNulls().create());
    }

    @Override
    public String contentType() {
        return "application/json";
    }

    @Override
    public final void writeData(Map<String, Object> data, ObjectOutput out) throws IOException {
        String json = this.gson.toJson(data);
        out.writeUTF(json);
    }

    @Override
    public final Map<String, Object> readData(ObjectInput in) throws IOException, ClassNotFoundException {
        String json = in.readUTF();
        TypeToken<Map<String, Object>> typeToken = new TypeToken<Map<String, Object>>(){};
        return (Map)this.gson.fromJson(json, (TypeToken)typeToken);
    }
}

