/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.serializer.plain_text;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.bsc.langgraph4j.serializer.StateSerializer;
import org.bsc.langgraph4j.state.AgentState;
import org.bsc.langgraph4j.state.AgentStateFactory;

public abstract class PlainTextStateSerializer<State extends AgentState>
extends StateSerializer<State> {
    protected PlainTextStateSerializer(AgentStateFactory<State> stateFactory) {
        super(stateFactory);
    }

    @Override
    public String contentType() {
        return "plain/text";
    }

    public Class<State> getStateType() {
        ParameterizedType parameterizedType;
        Type[] typeArguments;
        Type superClass = this.getClass().getGenericSuperclass();
        if (superClass instanceof ParameterizedType && (typeArguments = (parameterizedType = (ParameterizedType)superClass).getActualTypeArguments()).length > 0) {
            return (Class)typeArguments[0];
        }
        throw new IllegalStateException("Unable to determine state type");
    }

    public State read(String data) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bytesStream = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(bytesStream);){
            out.writeUTF(data);
            out.flush();
        }
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytesStream.toByteArray()));){
            Object object = this.read(in);
            return (State)object;
        }
    }

    public State read(Reader reader) throws IOException, ClassNotFoundException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line).append(System.lineSeparator());
            }
        }
        return this.read(sb.toString());
    }
}

