/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Objects;
import org.bsc.langgraph4j.serializer.Serializer;
import org.bsc.langgraph4j.state.AgentState;
import org.bsc.langgraph4j.state.AgentStateFactory;

public abstract class StateSerializer<State extends AgentState>
implements Serializer<State> {
    private final AgentStateFactory<State> stateFactory;

    protected StateSerializer(AgentStateFactory<State> stateFactory) {
        this.stateFactory = Objects.requireNonNull(stateFactory, "stateFactory cannot be null");
    }

    public final AgentStateFactory<State> stateFactory() {
        return this.stateFactory;
    }

    public final State stateOf(Map<String, Object> data) {
        Objects.requireNonNull(data, "data cannot be null");
        return (State)((AgentState)this.stateFactory.apply(data));
    }

    @Override
    public final State cloneObject(Map<String, Object> data) throws IOException, ClassNotFoundException {
        Objects.requireNonNull(data, "data cannot be null");
        return (State)this.cloneObject((AgentState)this.stateFactory().apply(data));
    }

    @Override
    public final void write(State object, ObjectOutput out) throws IOException {
        this.writeData(((AgentState)object).data(), out);
    }

    @Override
    public final State read(ObjectInput in) throws IOException, ClassNotFoundException {
        return (State)((AgentState)this.stateFactory().apply(this.readData(in)));
    }

    public abstract void writeData(Map<String, Object> var1, ObjectOutput var2) throws IOException;

    public abstract Map<String, Object> readData(ObjectInput var1) throws IOException, ClassNotFoundException;

    public final byte[] dataToBytes(Map<String, Object> data) throws IOException {
        Objects.requireNonNull(data, "object cannot be null");
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            ObjectOutputStream oas = new ObjectOutputStream(stream);
            this.writeData(data, oas);
            oas.flush();
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
    }

    public final Map<String, Object> dataFromBytes(byte[] bytes) throws IOException, ClassNotFoundException {
        Objects.requireNonNull(bytes, "bytes cannot be null");
        if (bytes.length == 0) {
            throw new IllegalArgumentException("bytes cannot be empty");
        }
        try (ByteArrayInputStream stream = new ByteArrayInputStream(bytes);){
            ObjectInputStream ois = new ObjectInputStream(stream);
            Map<String, Object> map = this.readData(ois);
            return map;
        }
    }
}

