/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.internal.node;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bsc.async.AsyncGenerator;
import org.bsc.langgraph4j.NodeOutput;
import org.bsc.langgraph4j.RunnableConfig;
import org.bsc.langgraph4j.action.AsyncNodeActionWithConfig;
import org.bsc.langgraph4j.internal.node.Node;
import org.bsc.langgraph4j.state.AgentState;
import org.bsc.langgraph4j.state.Channel;

public class ParallelNode<State extends AgentState>
extends Node<State> {
    private static final String PARALLEL_PREFIX = "__PARALLEL__";

    public static String formatNodeId(String nodeId) {
        return String.format("%s(%s)", PARALLEL_PREFIX, Objects.requireNonNull(nodeId, "nodeId cannot be null!"));
    }

    public ParallelNode(String id, List<AsyncNodeActionWithConfig<State>> actions, Map<String, Channel<?>> channels) {
        super(ParallelNode.formatNodeId(id), config -> new AsyncParallelNodeAction(ParallelNode.formatNodeId(id), actions, channels));
    }

    @Override
    public final boolean isParallel() {
        return true;
    }

    record AsyncParallelNodeAction<State extends AgentState>(String nodeId, List<AsyncNodeActionWithConfig<State>> actions, Map<String, Channel<?>> channels) implements AsyncNodeActionWithConfig<State>
    {
        private CompletableFuture<Map<String, Object>> evalGenerator(AsyncGenerator<NodeOutput<State>> generator, Map<String, Object> initPartialState) {
            return generator.collectAsync(new ArrayList(), ArrayList::add).thenApply(list -> {
                Map<String, Object> result = initPartialState;
                for (NodeOutput output : list) {
                    result = AgentState.updateState(result, ((AgentState)output.state()).data(), this.channels);
                }
                return result;
            });
        }

        private CompletableFuture<Map<String, Object>> evalNodeActionSync(AsyncNodeActionWithConfig<State> action, State state, RunnableConfig config) {
            return action.apply(state, config).thenCompose(partialState -> partialState.entrySet().stream().filter(e -> e.getValue() instanceof AsyncGenerator).findFirst().map(generatorEntry -> {
                Map<String, Object> partialStateWithoutGenerator = partialState.entrySet().stream().filter(e -> !Objects.equals(e.getKey(), generatorEntry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                return this.evalGenerator((AsyncGenerator)generatorEntry.getValue(), partialStateWithoutGenerator);
            }).orElse(CompletableFuture.completedFuture(partialState)));
        }

        private CompletableFuture<Map<String, Object>> evalNodeActionAsync(AsyncNodeActionWithConfig<State> action, State state, RunnableConfig config, Executor executor) {
            return CompletableFuture.supplyAsync(() -> this.evalNodeActionSync(action, state, config).join(), executor);
        }

        @Override
        public CompletableFuture<Map<String, Object>> apply(State state, RunnableConfig config) {
            Function evalNodeAction = config.metadata(this.nodeId).filter(value -> value instanceof Executor).map(Executor.class::cast).map(executor -> action -> this.evalNodeActionAsync((AsyncNodeActionWithConfig<State>)action, state, config, (Executor)executor)).orElseGet(() -> action -> this.evalNodeActionSync((AsyncNodeActionWithConfig<State>)action, state, config));
            CompletableFuture[] actionsArray = (CompletableFuture[])this.actions.stream().map(evalNodeAction).toArray(CompletableFuture[]::new);
            return CompletableFuture.allOf(actionsArray).thenApply(v -> Stream.of(actionsArray).map(CompletableFuture::join).reduce(state.data(), (result, actionResult) -> AgentState.updateState(result, (Map<String, Object>)actionResult, this.channels)));
        }
    }
}

