/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.internal.node;

import java.util.Objects;
import java.util.function.Function;
import org.bsc.langgraph4j.CompileConfig;
import org.bsc.langgraph4j.GraphStateException;
import org.bsc.langgraph4j.action.AsyncNodeActionWithConfig;
import org.bsc.langgraph4j.state.AgentState;

public class Node<State extends AgentState> {
    private final String id;
    private final ActionFactory<State> actionFactory;

    public Node(String id, ActionFactory<State> actionFactory) {
        this.id = id;
        this.actionFactory = actionFactory;
    }

    public Node(String id) {
        this(id, null);
    }

    public String id() {
        return this.id;
    }

    public ActionFactory<State> actionFactory() {
        return this.actionFactory;
    }

    public boolean isParallel() {
        return false;
    }

    public Node<State> withIdUpdated(Function<String, String> newId) {
        return new Node<State>(newId.apply(this.id), this.actionFactory);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof Node) {
            Node node = (Node)o;
            return Objects.equals(this.id, node.id);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return String.format("Node(%s,%s)", this.id, this.actionFactory != null ? "action" : "null");
    }

    public static interface ActionFactory<State extends AgentState> {
        public AsyncNodeActionWithConfig<State> apply(CompileConfig var1) throws GraphStateException;
    }
}

