/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.internal.edge;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bsc.langgraph4j.internal.edge.EdgeCondition;
import org.bsc.langgraph4j.state.AgentState;

public record EdgeValue<State extends AgentState>(String id, EdgeCondition<State> value) {
    public EdgeValue(String id) {
        this(id, null);
    }

    public EdgeValue(EdgeCondition<State> value) {
        this(null, value);
    }

    EdgeValue<State> withTargetIdsUpdated(Function<String, EdgeValue<State>> target) {
        if (this.id != null) {
            return target.apply(this.id);
        }
        Map<String, String> newMappings = this.value.mappings().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            EdgeValue v = (EdgeValue)target.apply((String)e.getValue());
            return v.id() != null ? v.id() : (String)e.getValue();
        }));
        return new EdgeValue<State>(null, new EdgeCondition<State>(this.value.action(), newMappings));
    }
}

