/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.internal.edge;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bsc.langgraph4j.GraphStateException;
import org.bsc.langgraph4j.StateGraph;
import org.bsc.langgraph4j.internal.edge.EdgeValue;
import org.bsc.langgraph4j.internal.node.Node;
import org.bsc.langgraph4j.state.AgentState;

public record Edge<State extends AgentState>(String sourceId, List<EdgeValue<State>> targets) {
    public Edge(String sourceId, EdgeValue<State> target) {
        this(sourceId, List.of(target));
    }

    public Edge(String id) {
        this(id, List.of());
    }

    public boolean isParallel() {
        return this.targets.size() > 1;
    }

    public EdgeValue<State> target() {
        if (this.isParallel()) {
            throw new IllegalStateException(String.format("Edge '%s' is parallel", this.sourceId));
        }
        return this.targets.get(0);
    }

    public boolean anyMatchByTargetId(String targetId) {
        return this.targets().stream().anyMatch(v -> v.id() != null ? Objects.equals(v.id(), targetId) : v.value().mappings().containsValue(targetId));
    }

    public Edge<State> withSourceAndTargetIdsUpdated(Node<State> node, Function<String, String> newSourceId, Function<String, EdgeValue<State>> newTarget) {
        List<EdgeValue<State>> newTargets = this.targets().stream().map(t -> t.withTargetIdsUpdated(newTarget)).toList();
        return new Edge<State>(newSourceId.apply(this.sourceId), newTargets);
    }

    public void validate(StateGraph.Nodes<State> nodes) throws GraphStateException {
        Set duplicates;
        Objects.requireNonNull(nodes, "nodes cannot be null");
        if (!Objects.equals(this.sourceId(), StateGraph.START) && !nodes.anyMatchById(this.sourceId())) {
            throw StateGraph.Errors.missingNodeReferencedByEdge.exception(this.sourceId());
        }
        if (this.isParallel() && !(duplicates = this.targets.stream().collect(Collectors.groupingBy(EdgeValue::id, Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet())).isEmpty()) {
            throw StateGraph.Errors.duplicateEdgeTargetError.exception(this.sourceId(), duplicates);
        }
        for (EdgeValue<State> target : this.targets) {
            this.validate(target, nodes);
        }
    }

    private void validate(EdgeValue<State> target, StateGraph.Nodes<State> nodes) throws GraphStateException {
        if (target.id() != null) {
            if (!Objects.equals(target.id(), StateGraph.END) && !nodes.anyMatchById(target.id())) {
                throw StateGraph.Errors.missingNodeReferencedByEdge.exception(target.id());
            }
        } else if (target.value() != null) {
            for (String nodeId : target.value().mappings().values()) {
                if (Objects.equals(nodeId, StateGraph.END) || nodes.anyMatchById(nodeId)) continue;
                throw StateGraph.Errors.missingNodeInEdgeMapping.exception(this.sourceId(), nodeId);
            }
        } else {
            throw StateGraph.Errors.invalidEdgeTarget.exception(this.sourceId());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Edge node = (Edge)o;
        return Objects.equals(this.sourceId, node.sourceId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.sourceId);
    }
}

