/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.diagram;

import org.bsc.langgraph4j.DiagramGenerator;
import org.bsc.langgraph4j.StateGraph;

public class PlantUMLGenerator
extends DiagramGenerator {
    @Override
    protected void appendHeader(DiagramGenerator.Context ctx) {
        if (ctx.isSubGraph()) {
            ctx.sb().append(String.format("rectangle %s [ {{\ntitle \"%s\"\n", ctx.title(), ctx.title())).append(String.format("circle \" \" as %s\n", StateGraph.START)).append(String.format("circle exit as %s\n", StateGraph.END));
        } else {
            ctx.sb().append(String.format("@startuml %s\n", ctx.titleToSnakeCase().orElse("unnamed"))).append("skinparam usecaseFontSize 14\n").append("skinparam usecaseStereotypeFontSize 12\n").append("skinparam hexagonFontSize 14\n").append("skinparam hexagonStereotypeFontSize 12\n").append(String.format("title \"%s\"\n", ctx.title())).append("footer\n\n").append("powered by langgraph4j\n").append("end footer\n").append(String.format("circle start<<input>> as %s\n", StateGraph.START)).append(String.format("circle stop as %s\n", StateGraph.END));
        }
    }

    @Override
    protected void appendFooter(DiagramGenerator.Context ctx) {
        if (ctx.isSubGraph()) {
            ctx.sb().append("\n}} ]\n");
        } else {
            ctx.sb().append("@enduml\n");
        }
    }

    @Override
    protected void call(DiagramGenerator.Context ctx, String from, String to, DiagramGenerator.CallStyle style) {
        StringBuilder stringBuilder = ctx.sb();
        stringBuilder.append(switch (style) {
            case DiagramGenerator.CallStyle.CONDITIONAL -> String.format("\"%s\" .down.> \"%s\"\n", from, to);
            default -> String.format("\"%s\" -down-> \"%s\"\n", from, to);
        });
    }

    @Override
    protected void call(DiagramGenerator.Context ctx, String from, String to, String description, DiagramGenerator.CallStyle style) {
        StringBuilder stringBuilder = ctx.sb();
        stringBuilder.append(switch (style) {
            case DiagramGenerator.CallStyle.CONDITIONAL -> String.format("\"%s\" .down.> \"%s\": \"%s\"\n", from, to, description);
            default -> String.format("\"%s\" -down-> \"%s\": \"%s\"\n", from, to, description);
        });
    }

    @Override
    protected void declareConditionalStart(DiagramGenerator.Context ctx, String name) {
        ctx.sb().append(String.format("hexagon \"check state\" as %s<<Condition>>\n", name));
    }

    @Override
    protected void declareNode(DiagramGenerator.Context ctx, String name) {
        ctx.sb().append(String.format("usecase \"%s\"<<Node>>\n", name));
    }

    @Override
    protected void declareConditionalEdge(DiagramGenerator.Context ctx, int ordinal) {
        ctx.sb().append(String.format("hexagon \"check state\" as condition%d<<Condition>>\n", ordinal));
    }

    @Override
    protected void commentLine(DiagramGenerator.Context ctx, boolean yesOrNo) {
        if (yesOrNo) {
            ctx.sb().append("'");
        }
    }
}

