/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.diagram;

import java.util.Optional;
import org.bsc.langgraph4j.DiagramGenerator;
import org.bsc.langgraph4j.StateGraph;

public class MermaidGenerator
extends DiagramGenerator {
    public static final char SUBGRAPH_PREFIX = '_';

    @Override
    protected void appendHeader(DiagramGenerator.Context ctx) {
        if (ctx.isSubGraph()) {
            ctx.sb().append(String.format("subgraph %s\n", ctx.title())).append(String.format("\t%1$c%2$s((start)):::%1$c%2$s\n", Character.valueOf('_'), StateGraph.START)).append(String.format("\t%1$c%2$s((stop)):::%1$c%2$s\n", Character.valueOf('_'), StateGraph.END));
        } else {
            Optional.ofNullable(ctx.title()).map(title -> ctx.sb().append(String.format("---\ntitle: %s\n---\n", title))).orElseGet(ctx::sb).append("flowchart TD\n").append(String.format("\t%s((start))\n", StateGraph.START)).append(String.format("\t%s((stop))\n", StateGraph.END));
        }
    }

    @Override
    protected void appendFooter(DiagramGenerator.Context ctx) {
        if (ctx.isSubGraph()) {
            ctx.sb().append("end\n");
        } else {
            ctx.sb().append('\n').append(String.format("\tclassDef %c%s fill:black,stroke-width:1px,font-size:xx-small;\n", Character.valueOf('_'), StateGraph.START)).append(String.format("\tclassDef %c%s fill:black,stroke-width:1px,font-size:xx-small;\n", Character.valueOf('_'), StateGraph.END));
        }
    }

    @Override
    protected void declareConditionalStart(DiagramGenerator.Context ctx, String name) {
        ctx.sb().append('\t');
        if (ctx.isSubGraph()) {
            ctx.sb().append('_');
        }
        ctx.sb().append(String.format("%s{\"check state\"}\n", name));
    }

    @Override
    protected void declareNode(DiagramGenerator.Context ctx, String name) {
        ctx.sb().append('\t');
        if (ctx.isSubGraph()) {
            ctx.sb().append('_');
        }
        ctx.sb().append(String.format("%s(\"%s\")\n", name, name));
    }

    @Override
    protected void declareConditionalEdge(DiagramGenerator.Context ctx, int ordinal) {
        ctx.sb().append('\t');
        if (ctx.isSubGraph()) {
            ctx.sb().append('_');
        }
        ctx.sb().append(String.format("condition%d{\"check state\"}\n", ordinal));
    }

    @Override
    protected void commentLine(DiagramGenerator.Context ctx, boolean yesOrNo) {
        if (yesOrNo) {
            ctx.sb().append("\t%%");
        }
    }

    @Override
    protected void call(DiagramGenerator.Context ctx, String from, String to, DiagramGenerator.CallStyle style) {
        ctx.sb().append('\t');
        if (ctx.isSubGraph()) {
            StringBuilder stringBuilder = ctx.sb();
            stringBuilder.append(switch (style) {
                case DiagramGenerator.CallStyle.CONDITIONAL -> String.format("%1$c%2$s:::%1$c%2$s -.-> %1$c%3$s:::%1$c%3$s\n", Character.valueOf('_'), from, to);
                default -> String.format("%1$c%2$s:::%1$c%2$s --> %1$c%3$s:::%1$c%3$s\n", Character.valueOf('_'), from, to);
            });
        } else {
            StringBuilder stringBuilder = ctx.sb();
            stringBuilder.append(switch (style) {
                case DiagramGenerator.CallStyle.CONDITIONAL -> String.format("%1$s:::%1$s -.-> %2$s:::%2$s\n", from, to);
                default -> String.format("%1$s:::%1$s --> %2$s:::%2$s\n", from, to);
            });
        }
    }

    @Override
    protected void call(DiagramGenerator.Context ctx, String from, String to, String description, DiagramGenerator.CallStyle style) {
        ctx.sb().append('\t');
        if (ctx.isSubGraph()) {
            StringBuilder stringBuilder = ctx.sb();
            stringBuilder.append(switch (style) {
                case DiagramGenerator.CallStyle.CONDITIONAL -> String.format("%1$s%2$s:::%1$c%2$s -.->|%3$s| %1$s%4$s:::%1$c%4$s\n", Character.valueOf('_'), from, description, to);
                default -> String.format("%1$s%2$s:::%1$c%2$s -->|%3$s| %1$s%4$s:::%1$c%4$s\n", Character.valueOf('_'), from, description, to);
            });
        } else {
            StringBuilder stringBuilder = ctx.sb();
            stringBuilder.append(switch (style) {
                case DiagramGenerator.CallStyle.CONDITIONAL -> String.format("%1$s:::%1$s -.->|%2$s| %3$s:::%3$s\n", from, description, to);
                default -> String.format("%1$s:::%1$s -->|%2$s| %3$s:::%3$s\n", from, description, to);
            });
        }
    }
}

