/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.checkpoint;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import org.bsc.langgraph4j.RunnableConfig;
import org.bsc.langgraph4j.checkpoint.BaseCheckpointSaver;
import org.bsc.langgraph4j.checkpoint.Checkpoint;
import org.bsc.langgraph4j.checkpoint.HasVersions;
import org.bsc.langgraph4j.checkpoint.MemorySaver;

public class VersionedMemorySaver
implements BaseCheckpointSaver,
HasVersions {
    final Map<String, TreeMap<Integer, BaseCheckpointSaver.Tag>> _checkpointsHistoryByThread = new HashMap<String, TreeMap<Integer, BaseCheckpointSaver.Tag>>();
    final MemorySaver noVersionSaver = new MemorySaver();
    private final ReentrantLock _lock = new ReentrantLock();

    private Optional<TreeMap<Integer, BaseCheckpointSaver.Tag>> getCheckpointHistoryByThread(String threadId) {
        return Optional.ofNullable(this._checkpointsHistoryByThread.get(threadId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Optional<BaseCheckpointSaver.Tag> getTagByVersion(TreeMap<Integer, BaseCheckpointSaver.Tag> checkpointsHistory, int threadVersion) {
        this._lock.lock();
        try {
            Optional<BaseCheckpointSaver.Tag> optional = Optional.ofNullable(checkpointsHistory.get(threadVersion));
            return optional;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Collection<Checkpoint> getCheckpointsByVersion(String threadId, int threadVersion) {
        this._lock.lock();
        try {
            Collection collection = this.getCheckpointHistoryByThread(threadId).map(history -> (BaseCheckpointSaver.Tag)history.get(threadVersion)).map(BaseCheckpointSaver.Tag::checkpoints).orElseThrow(() -> new IllegalArgumentException(String.format("Version %s for thread %s not found", threadVersion, threadId)));
            return collection;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public Collection<Integer> versionsByThreadId(String threadId) {
        return this.getCheckpointHistoryByThread(Optional.ofNullable(threadId).orElse("$default")).map(history -> history.keySet()).orElse(Collections.emptyList());
    }

    @Override
    public Optional<Integer> lastVersionByThreadId(String threadId) {
        return this.getCheckpointHistoryByThread(Optional.ofNullable(threadId).orElse("$default")).map(TreeMap::lastKey);
    }

    @Override
    public Collection<Checkpoint> list(RunnableConfig config) {
        this._lock.lock();
        try {
            Collection<Checkpoint> collection = this.noVersionSaver.list(config);
            return collection;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public Optional<Checkpoint> get(RunnableConfig config) {
        this._lock.lock();
        try {
            Optional<Checkpoint> optional = this.noVersionSaver.get(config);
            return optional;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RunnableConfig put(RunnableConfig config, Checkpoint checkpoint) throws Exception {
        this._lock.lock();
        try {
            RunnableConfig runnableConfig = this.noVersionSaver.put(config, checkpoint);
            return runnableConfig;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseCheckpointSaver.Tag release(RunnableConfig config) throws Exception {
        this._lock.lock();
        try {
            String threadId = config.threadId().orElse("$default");
            BaseCheckpointSaver.Tag tag = this.noVersionSaver.release(config);
            TreeMap checkpointsHistory = this._checkpointsHistoryByThread.computeIfAbsent(threadId, k -> new TreeMap());
            Integer threadVersion = Optional.ofNullable(checkpointsHistory.lastEntry()).map(Map.Entry::getKey).orElse(0);
            checkpointsHistory.put(threadVersion + 1, tag);
            BaseCheckpointSaver.Tag tag2 = tag;
            return tag2;
        }
        finally {
            this._lock.unlock();
        }
    }
}

