/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.checkpoint;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.IntStream;
import org.bsc.langgraph4j.RunnableConfig;
import org.bsc.langgraph4j.checkpoint.BaseCheckpointSaver;
import org.bsc.langgraph4j.checkpoint.Checkpoint;
import org.bsc.langgraph4j.utils.TryFunction;

public class MemorySaver
implements BaseCheckpointSaver {
    final Map<String, LinkedList<Checkpoint>> _checkpointsByThread = new HashMap<String, LinkedList<Checkpoint>>();
    private final ReentrantLock _lock = new ReentrantLock();

    protected LinkedList<Checkpoint> loadedCheckpoints(RunnableConfig config, LinkedList<Checkpoint> checkpoints) throws Exception {
        return checkpoints;
    }

    protected void insertedCheckpoint(RunnableConfig config, LinkedList<Checkpoint> checkpoints, Checkpoint checkpoint) throws Exception {
    }

    protected void updatedCheckpoint(RunnableConfig config, LinkedList<Checkpoint> checkpoints, Checkpoint checkpoint) throws Exception {
    }

    protected void releasedCheckpoints(RunnableConfig config, LinkedList<Checkpoint> checkpoints, BaseCheckpointSaver.Tag releaseTag) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <T> T loadOrInitCheckpoints(RunnableConfig config, TryFunction<LinkedList<Checkpoint>, T, Exception> transformer) throws Exception {
        this._lock.lock();
        try {
            String threadId = config.threadId().orElse("$default");
            T t = transformer.tryApply(this.loadedCheckpoints(config, this._checkpointsByThread.computeIfAbsent(threadId, k -> new LinkedList())));
            return t;
        }
        finally {
            this._lock.unlock();
        }
    }

    final Optional<Checkpoint> getLast(LinkedList<Checkpoint> checkpoints, RunnableConfig config) {
        return checkpoints.isEmpty() ? Optional.empty() : Optional.ofNullable(checkpoints.peek());
    }

    protected final Collection<Checkpoint> remove(String threadId) {
        return this._checkpointsByThread.remove(Objects.requireNonNull(threadId));
    }

    @Override
    public final Collection<Checkpoint> list(RunnableConfig config) {
        try {
            return this.loadOrInitCheckpoints(config, Collections::unmodifiableCollection);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final Optional<Checkpoint> get(RunnableConfig config) {
        try {
            return this.loadOrInitCheckpoints(config, checkpoints -> {
                if (config.checkPointId().isPresent()) {
                    return config.checkPointId().flatMap(id -> checkpoints.stream().filter(checkpoint -> checkpoint.getId().equals(id)).findFirst());
                }
                return this.getLast((LinkedList<Checkpoint>)checkpoints, config);
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final RunnableConfig put(RunnableConfig config, Checkpoint checkpoint) throws Exception {
        return this.loadOrInitCheckpoints(config, checkpoints -> {
            if (config.checkPointId().isPresent()) {
                String checkPointId = config.checkPointId().get();
                int index = IntStream.range(0, checkpoints.size()).filter(i -> ((Checkpoint)checkpoints.get(i)).getId().equals(checkPointId)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("Checkpoint with id %s not found!", checkPointId)));
                checkpoints.set(index, checkpoint);
                this.updatedCheckpoint(config, (LinkedList<Checkpoint>)checkpoints, checkpoint);
                return config;
            }
            checkpoints.push(checkpoint);
            this.insertedCheckpoint(config, (LinkedList<Checkpoint>)checkpoints, checkpoint);
            return RunnableConfig.builder(config).checkPointId(checkpoint.getId()).build();
        });
    }

    @Override
    public final BaseCheckpointSaver.Tag release(RunnableConfig config) throws Exception {
        return this.loadOrInitCheckpoints(config, checkpoints -> {
            String threadId = config.threadId().orElse("$default");
            BaseCheckpointSaver.Tag tag = new BaseCheckpointSaver.Tag(threadId, this.remove(threadId));
            this.releasedCheckpoints(config, (LinkedList<Checkpoint>)checkpoints, tag);
            return tag;
        });
    }
}

