/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.checkpoint;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.LinkedList;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.bsc.langgraph4j.RunnableConfig;
import org.bsc.langgraph4j.checkpoint.BaseCheckpointSaver;
import org.bsc.langgraph4j.checkpoint.CheckPointSerializer;
import org.bsc.langgraph4j.checkpoint.Checkpoint;
import org.bsc.langgraph4j.checkpoint.MemorySaver;
import org.bsc.langgraph4j.serializer.Serializer;
import org.bsc.langgraph4j.serializer.StateSerializer;
import org.bsc.langgraph4j.state.AgentState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemSaver
extends MemorySaver {
    private static final Logger log = LoggerFactory.getLogger(FileSystemSaver.class);
    public static final String EXTENSION = ".saver";
    private final Path targetFolder;
    private final Serializer<Checkpoint> serializer;

    public FileSystemSaver(Path targetFolder, StateSerializer<? extends AgentState> stateSerializer) {
        Objects.requireNonNull(stateSerializer, "stateSerializer cannot be null");
        this.targetFolder = Objects.requireNonNull(targetFolder, "targetFolder cannot be null");
        this.serializer = new CheckPointSerializer(stateSerializer);
        File targetFolderAsFile = targetFolder.toFile();
        if (targetFolderAsFile.exists()) {
            if (targetFolderAsFile.isFile()) {
                throw new IllegalArgumentException(String.format("targetFolder '%s' must be a folder", targetFolder));
            }
        } else if (!targetFolderAsFile.mkdirs()) {
            throw new IllegalArgumentException(String.format("targetFolder '%s' cannot be created", targetFolder));
        }
    }

    private String getBaseName(RunnableConfig config) {
        String threadId = config.threadId().orElse("$default");
        return String.format("thread-%s", threadId);
    }

    private Path getPath(RunnableConfig config) {
        return Paths.get(this.targetFolder.toString(), this.getBaseName(config).concat(EXTENSION));
    }

    private File getFile(RunnableConfig config) {
        return this.getPath(config).toFile();
    }

    private void serialize(LinkedList<Checkpoint> checkpoints, File outFile) throws IOException {
        Objects.requireNonNull(checkpoints, "checkpoints cannot be null");
        Objects.requireNonNull(outFile, "outFile cannot be null");
        try (ObjectOutputStream oos = new ObjectOutputStream(Files.newOutputStream(outFile.toPath(), new OpenOption[0]));){
            oos.writeInt(checkpoints.size());
            for (Checkpoint checkpoint : checkpoints) {
                this.serializer.write(checkpoint, oos);
            }
        }
    }

    private void deserialize(File file, LinkedList<Checkpoint> result) throws IOException, ClassNotFoundException {
        Objects.requireNonNull(file, "file cannot be null");
        Objects.requireNonNull(result, "result cannot be null");
        try (ObjectInputStream ois = new ObjectInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            int size = ois.readInt();
            for (int i = 0; i < size; ++i) {
                result.add(this.serializer.read(ois));
            }
        }
    }

    @Override
    protected LinkedList<Checkpoint> loadedCheckpoints(RunnableConfig config, LinkedList<Checkpoint> checkpoints) throws Exception {
        File targetFile = this.getFile(config);
        if (targetFile.exists() && checkpoints.isEmpty()) {
            this.deserialize(targetFile, checkpoints);
        }
        return checkpoints;
    }

    @Override
    protected void insertedCheckpoint(RunnableConfig config, LinkedList<Checkpoint> checkpoints, Checkpoint checkpoint) throws Exception {
        File targetFile = this.getFile(config);
        this.serialize(checkpoints, targetFile);
    }

    @Override
    protected void updatedCheckpoint(RunnableConfig config, LinkedList<Checkpoint> checkpoints, Checkpoint checkpoint) throws Exception {
        this.insertedCheckpoint(config, checkpoints, checkpoint);
    }

    @Override
    protected void releasedCheckpoints(RunnableConfig config, LinkedList<Checkpoint> checkpoints, BaseCheckpointSaver.Tag releaseTag) throws Exception {
        Path currentPath = this.getPath(config);
        if (!Files.exists(currentPath, new LinkOption[0])) {
            log.warn("file {} doesn't exist. Skipping file operations.", (Object)currentPath);
            return;
        }
        Pattern versionPattern = Pattern.compile(String.format("%s-v(\\d+)\\%s$", this.getBaseName(config), EXTENSION));
        int maxVersion = 0;
        try (Stream<Path> stream = Files.list(this.targetFolder);){
            maxVersion = stream.map(path -> path.getFileName().toString()).map(versionPattern::matcher).filter(Matcher::matches).mapToInt(matcher -> Integer.parseInt(matcher.group(1))).max().orElse(0);
        }
        catch (IOException e) {
            log.error("Failed to list directory {} to determine next version number for backup. Skipping file operations.", (Object)this.targetFolder, (Object)e);
            return;
        }
        int nextVersion = maxVersion + 1;
        String backupFilename = String.format("%s-v%d%s", this.getBaseName(config), nextVersion, EXTENSION);
        Path backupPath = this.targetFolder.resolve(backupFilename);
        Files.copy(currentPath, backupPath, StandardCopyOption.REPLACE_EXISTING);
        Files.delete(currentPath);
    }

    public boolean deleteFile(RunnableConfig config) {
        File targetFile = this.getFile(config);
        return targetFile.exists() && targetFile.delete();
    }
}

