/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.checkpoint;

import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bsc.langgraph4j.state.AgentState;
import org.bsc.langgraph4j.state.Channel;

public class Checkpoint {
    private final String id;
    private Map<String, Object> state = null;
    private String nodeId = null;
    private String nextNodeId = null;

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getState() {
        return this.state;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getNextNodeId() {
        return this.nextNodeId;
    }

    public static Checkpoint copyOf(Checkpoint checkpoint) {
        Objects.requireNonNull(checkpoint, "checkpoint cannot be null");
        return new Checkpoint(UUID.randomUUID().toString(), checkpoint.state, checkpoint.nodeId, checkpoint.nextNodeId);
    }

    private Checkpoint(String id, Map<String, Object> state, String nodeId, String nextNodeId) {
        this.id = Objects.requireNonNull(id, "id cannot be null");
        this.state = Objects.requireNonNull(state, "state cannot be null");
        this.nodeId = Objects.requireNonNull(nodeId, "nodeId cannot be null");
        this.nextNodeId = Objects.requireNonNull(nextNodeId, "Checkpoint.nextNodeId cannot be null");
    }

    public static Builder builder() {
        return new Builder();
    }

    public Checkpoint updateState(Map<String, Object> values, Map<String, Channel<?>> channels) {
        return new Checkpoint(this.id, AgentState.updateState(this.state, values, channels), this.nodeId, this.nextNodeId);
    }

    public String toString() {
        return String.format("Checkpoint{ id=%s, nodeId=%s, nextNodeId=%s, state=%s }", this.id, this.nodeId, this.nextNodeId, this.state);
    }

    public static class Builder {
        private String id = UUID.randomUUID().toString();
        private Map<String, Object> state = null;
        private String nodeId = null;
        private String nextNodeId = null;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder state(AgentState state) {
            this.state = state.data();
            return this;
        }

        public Builder state(Map<String, Object> state) {
            this.state = state;
            return this;
        }

        public Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder nextNodeId(String nextNodeId) {
            this.nextNodeId = nextNodeId;
            return this;
        }

        public Checkpoint build() {
            return new Checkpoint(this.id, this.state, this.nodeId, this.nextNodeId);
        }
    }
}

