/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.agent;

import java.util.Map;
import java.util.Objects;
import org.bsc.langgraph4j.GraphStateException;
import org.bsc.langgraph4j.StateGraph;
import org.bsc.langgraph4j.action.AsyncCommandAction;
import org.bsc.langgraph4j.action.AsyncNodeActionWithConfig;
import org.bsc.langgraph4j.prebuilt.MessagesState;
import org.bsc.langgraph4j.serializer.StateSerializer;
import org.bsc.langgraph4j.state.Channel;
import org.bsc.langgraph4j.utils.EdgeMappings;

public interface Agent {
    public static final String CONTINUE_LABEL = "continue";
    public static final String END_LABEL = "end";

    public static <M, S extends MessagesState<M>> Builder<M, S> builder() {
        return new Builder();
    }

    public static class Builder<M, S extends MessagesState<M>> {
        private StateSerializer<S> stateSerializer;
        private AsyncNodeActionWithConfig<S> callModelAction;
        private AsyncNodeActionWithConfig<S> executeToolsAction;
        private AsyncCommandAction<S> shouldContinueEdge;
        private Map<String, Channel<?>> schema;

        public Builder<M, S> stateSerializer(StateSerializer<S> stateSerializer) {
            this.stateSerializer = stateSerializer;
            return this;
        }

        public Builder<M, S> schema(Map<String, Channel<?>> schema) {
            this.schema = schema;
            return this;
        }

        public Builder<M, S> callModelAction(AsyncNodeActionWithConfig<S> callModelAction) {
            this.callModelAction = callModelAction;
            return this;
        }

        public Builder<M, S> executeToolsAction(AsyncNodeActionWithConfig<S> executeToolsAction) {
            this.executeToolsAction = executeToolsAction;
            return this;
        }

        public Builder<M, S> shouldContinueEdge(AsyncCommandAction<S> shouldContinueEdge) {
            this.shouldContinueEdge = shouldContinueEdge;
            return this;
        }

        public StateGraph<S> build() throws GraphStateException {
            return new StateGraph<S>(Objects.requireNonNull(this.schema, "schema is required!"), Objects.requireNonNull(this.stateSerializer, "stateSerializer is required!")).addEdge(StateGraph.START, "agent").addNode("agent", Objects.requireNonNull(this.callModelAction, "callModelAction is required!")).addNode("action", Objects.requireNonNull(this.executeToolsAction, "executeToolsAction is required!")).addConditionalEdges("agent", Objects.requireNonNull(this.shouldContinueEdge, "shouldContinue is required!"), EdgeMappings.builder().to("action", Agent.CONTINUE_LABEL).toEND(Agent.END_LABEL).build()).addEdge("action", "agent");
        }
    }
}

