/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.action;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bsc.langgraph4j.HasMetadata;
import org.bsc.langgraph4j.state.AgentState;
import org.bsc.langgraph4j.utils.CollectionsUtils;

public final class InterruptionMetadata<State extends AgentState>
implements HasMetadata<Builder<State>> {
    private final String nodeId;
    private final State state;
    private final Map<String, Object> metadata;

    private InterruptionMetadata(Builder<State> builder) {
        this.metadata = builder.metadata();
        this.nodeId = Objects.requireNonNull(builder.nodeId, "nodeId cannot be null!");
        this.state = (AgentState)Objects.requireNonNull(builder.state, "state cannot be null!");
    }

    public String nodeId() {
        return this.nodeId;
    }

    public State state() {
        return this.state;
    }

    @Override
    public Optional<Object> metadata(String key) {
        return Optional.ofNullable(this.metadata).map(m -> m.get(key));
    }

    public String toString() {
        return String.format("InterruptionMetadata{\n\tnodeId='%s',\n\tstate=%s,\n\tmetadata=%s\n}", this.nodeId, this.state, CollectionsUtils.toString(this.metadata));
    }

    public static <State extends AgentState> Builder<State> builder(String nodeId, State state) {
        return new Builder<State>(nodeId, state);
    }

    public static class Builder<State extends AgentState>
    extends HasMetadata.Builder<Builder<State>> {
        final String nodeId;
        final State state;

        public Builder(String nodeId, State state) {
            this.nodeId = nodeId;
            this.state = state;
        }

        public InterruptionMetadata<State> build() {
            return new InterruptionMetadata(this);
        }
    }
}

