/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.bsc.langgraph4j.CompiledGraph;
import org.bsc.langgraph4j.HasMetadata;
import org.bsc.langgraph4j.internal.node.ParallelNode;

public final class RunnableConfig
implements HasMetadata<Builder> {
    private final String threadId;
    private final String checkPointId;
    private final String nextNode;
    private final CompiledGraph.StreamMode streamMode;
    private final Map<String, Object> metadata;

    public CompiledGraph.StreamMode streamMode() {
        return this.streamMode;
    }

    public Optional<String> threadId() {
        return Optional.ofNullable(this.threadId);
    }

    public Optional<String> checkPointId() {
        return Optional.ofNullable(this.checkPointId);
    }

    public Optional<String> nextNode() {
        return Optional.ofNullable(this.nextNode);
    }

    public RunnableConfig withStreamMode(CompiledGraph.StreamMode streamMode) {
        if (this.streamMode == streamMode) {
            return this;
        }
        return RunnableConfig.builder(this).streamMode(streamMode).build();
    }

    public RunnableConfig withCheckPointId(String checkPointId) {
        if (Objects.equals(this.checkPointId, checkPointId)) {
            return this;
        }
        return RunnableConfig.builder(this).checkPointId(checkPointId).build();
    }

    @Override
    public Optional<Object> metadata(String key) {
        if (key == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.metadata).map(m -> m.get(key));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RunnableConfig config) {
        return new Builder(config);
    }

    private RunnableConfig(Builder builder) {
        this.threadId = builder.threadId;
        this.checkPointId = builder.checkPointId;
        this.nextNode = builder.nextNode;
        this.streamMode = builder.streamMode;
        this.metadata = Optional.ofNullable(builder.metadata()).map(Map::copyOf).orElse(null);
    }

    public String toString() {
        return String.format("RunnableConfig{ threadId=%s, checkPointId=%s, nextNode=%s, streamMode=%s }", new Object[]{this.threadId, this.checkPointId, this.nextNode, this.streamMode});
    }

    public static class Builder
    extends HasMetadata.Builder<Builder> {
        private String threadId;
        private String checkPointId;
        private String nextNode;
        private CompiledGraph.StreamMode streamMode = CompiledGraph.StreamMode.VALUES;

        Builder() {
        }

        Builder(RunnableConfig config) {
            super(Objects.requireNonNull(config, (String)"config cannot be null!").metadata);
            this.threadId = config.threadId;
            this.checkPointId = config.checkPointId;
            this.nextNode = config.nextNode;
            this.streamMode = config.streamMode;
        }

        public Builder threadId(String threadId) {
            this.threadId = threadId;
            return this;
        }

        public Builder checkPointId(String checkPointId) {
            this.checkPointId = checkPointId;
            return this;
        }

        public Builder nextNode(String nextNode) {
            this.nextNode = nextNode;
            return this;
        }

        public Builder streamMode(CompiledGraph.StreamMode streamMode) {
            this.streamMode = streamMode;
            return this;
        }

        public Builder addParallelNodeExecutor(String nodeId, Executor executor) {
            return (Builder)this.addMetadata(ParallelNode.formatNodeId(nodeId), Objects.requireNonNull(executor, "executor cannot be null!"));
        }

        public RunnableConfig build() {
            return new RunnableConfig(this);
        }
    }
}

