/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bsc.langgraph4j.CompileConfig;
import org.bsc.langgraph4j.GraphStateException;
import org.bsc.langgraph4j.StateGraph;
import org.bsc.langgraph4j.internal.edge.Edge;
import org.bsc.langgraph4j.internal.edge.EdgeValue;
import org.bsc.langgraph4j.internal.node.SubStateGraphNode;
import org.bsc.langgraph4j.state.AgentState;

record ProcessedNodesEdgesAndConfig<State extends AgentState>(StateGraph.Nodes<State> nodes, StateGraph.Edges<State> edges, Set<String> interruptsBefore, Set<String> interruptsAfter) {
    ProcessedNodesEdgesAndConfig(StateGraph<State> stateGraph, CompileConfig config) {
        this(stateGraph.nodes, stateGraph.edges, config.interruptsBefore(), config.interruptsAfter());
    }

    static <State extends AgentState> ProcessedNodesEdgesAndConfig<State> process(StateGraph<State> stateGraph, CompileConfig config) throws GraphStateException {
        List subgraphNodes = stateGraph.nodes.onlySubStateGraphNodes();
        if (subgraphNodes.isEmpty()) {
            return new ProcessedNodesEdgesAndConfig<State>(stateGraph, config);
        }
        Set<String> interruptsBefore = config.interruptsBefore();
        Set<String> interruptsAfter = config.interruptsAfter();
        StateGraph.Nodes nodes = new StateGraph.Nodes(stateGraph.nodes.exceptSubStateGraphNodes());
        StateGraph.Edges edges = new StateGraph.Edges(stateGraph.edges.elements);
        for (SubStateGraphNode subgraphNode : subgraphNodes) {
            StateGraph sgWorkflow = subgraphNode.subGraph();
            Edge sgEdgeStart = sgWorkflow.edges.edgeBySourceId(StateGraph.START).orElseThrow();
            if (sgEdgeStart.isParallel()) {
                throw new GraphStateException("subgraph not support start with parallel branches yet!");
            }
            EdgeValue sgEdgeStartTarget = sgEdgeStart.target();
            if (sgEdgeStartTarget.id() == null) {
                throw new GraphStateException(String.format("the target for node '%s' is null!", subgraphNode.id()));
            }
            String sgEdgeStartRealTargetId = subgraphNode.formatId(sgEdgeStartTarget.id());
            interruptsBefore = interruptsBefore.stream().map(interrupt -> Objects.equals(subgraphNode.id(), interrupt) ? sgEdgeStartRealTargetId : interrupt).collect(Collectors.toUnmodifiableSet());
            List edgesWithSubgraphTargetId = edges.edgesByTargetId(subgraphNode.id());
            if (edgesWithSubgraphTargetId.isEmpty()) {
                throw new GraphStateException(String.format("the node '%s' is not present as target in graph!", subgraphNode.id()));
            }
            for (Edge edgeWithSubgraphTargetId : edgesWithSubgraphTargetId) {
                Edge newEdge = edgeWithSubgraphTargetId.withSourceAndTargetIdsUpdated(subgraphNode, Function.identity(), id -> new EdgeValue(Objects.equals(id, subgraphNode.id()) ? subgraphNode.formatId(sgEdgeStartTarget.id()) : id));
                edges.elements.remove(edgeWithSubgraphTargetId);
                edges.elements.add(newEdge);
            }
            List sgEdgesEnd = sgWorkflow.edges.edgesByTargetId(StateGraph.END);
            Edge edgeWithSubgraphSourceId = edges.edgeBySourceId(subgraphNode.id()).orElseThrow();
            if (edgeWithSubgraphSourceId.isParallel()) {
                throw new GraphStateException("subgraph not support routes to parallel branches yet!");
            }
            if (interruptsAfter.contains(subgraphNode.id())) {
                String exceptionMessage = edgeWithSubgraphSourceId.target().id() == null ? "'interruption after' on subgraph is not supported yet!" : String.format("'interruption after' on subgraph is not supported yet! consider to use 'interruption before' node: '%s'", edgeWithSubgraphSourceId.target().id());
                throw new GraphStateException(exceptionMessage);
            }
            sgEdgesEnd.stream().map(e -> e.withSourceAndTargetIdsUpdated(subgraphNode, subgraphNode::formatId, id -> Objects.equals(id, StateGraph.END) ? edgeWithSubgraphSourceId.target() : new EdgeValue(subgraphNode.formatId((String)id)))).forEach(edges.elements::add);
            edges.elements.remove(edgeWithSubgraphSourceId);
            sgWorkflow.edges.elements.stream().filter(e -> !Objects.equals(e.sourceId(), StateGraph.START)).filter(e -> !e.anyMatchByTargetId(StateGraph.END)).map(e -> e.withSourceAndTargetIdsUpdated(subgraphNode, subgraphNode::formatId, id -> new EdgeValue(subgraphNode.formatId((String)id)))).forEach(edges.elements::add);
            sgWorkflow.nodes.elements.stream().map(n -> n.withIdUpdated(subgraphNode::formatId)).forEach(nodes.elements::add);
        }
        return new ProcessedNodesEdgesAndConfig(nodes, edges, interruptsBefore, interruptsAfter);
    }
}

