/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j;

import java.util.Objects;
import java.util.Optional;
import org.bsc.langgraph4j.StateGraph;
import org.bsc.langgraph4j.SubGraphNode;
import org.bsc.langgraph4j.internal.edge.Edge;
import org.bsc.langgraph4j.internal.edge.EdgeCondition;
import org.bsc.langgraph4j.internal.node.Node;
import org.bsc.langgraph4j.state.AgentState;

public abstract class DiagramGenerator {
    protected abstract void appendHeader(Context var1);

    protected abstract void appendFooter(Context var1);

    protected abstract void call(Context var1, String var2, String var3, CallStyle var4);

    protected abstract void call(Context var1, String var2, String var3, String var4, CallStyle var5);

    protected abstract void declareConditionalStart(Context var1, String var2);

    protected abstract void declareNode(Context var1, String var2);

    protected abstract void declareConditionalEdge(Context var1, int var2);

    protected abstract void commentLine(Context var1, boolean var2);

    public final <State extends AgentState> String generate(StateGraph.Nodes<State> nodes, StateGraph.Edges<State> edges, String title, boolean printConditionalEdge) {
        return this.generate(nodes, edges, Context.builder().title(title).isSubGraph(false).printConditionalEdge(printConditionalEdge).build()).toString();
    }

    protected final <State extends AgentState> Context generate(StateGraph.Nodes<State> nodes, StateGraph.Edges<State> edges, Context ctx) {
        this.appendHeader(ctx);
        for (Node n : nodes.elements) {
            if (n instanceof SubGraphNode) {
                SubGraphNode subGraphNode = (SubGraphNode)((Object)n);
                StateGraph subGraph = subGraphNode.subGraph();
                Context subgraphCtx = this.generate(subGraph.nodes, subGraph.edges, Context.builder().title(n.id()).printConditionalEdge(ctx.printConditionalEdge).isSubGraph(true).build());
                ctx.sb().append(subgraphCtx);
                continue;
            }
            this.declareNode(ctx, n.id());
        }
        int[] conditionalEdgeCount = new int[]{0};
        edges.elements.stream().filter(e -> !Objects.equals(e.sourceId(), StateGraph.START)).filter(e -> !e.isParallel()).forEach(e -> {
            if (e.target().value() != null) {
                conditionalEdgeCount[0] = conditionalEdgeCount[0] + 1;
                this.commentLine(ctx, !ctx.printConditionalEdge());
                this.declareConditionalEdge(ctx, conditionalEdgeCount[0]);
            }
        });
        Edge edgeStart = edges.elements.stream().filter(e -> Objects.equals(e.sourceId(), StateGraph.START)).findFirst().orElseThrow();
        if (edgeStart.isParallel()) {
            edgeStart.targets().forEach(target -> this.call(ctx, StateGraph.START, target.id(), CallStyle.START));
        } else if (edgeStart.target().id() != null) {
            this.call(ctx, StateGraph.START, edgeStart.target().id(), CallStyle.START);
        } else if (edgeStart.target().value() != null) {
            String conditionName = "startcondition";
            this.commentLine(ctx, !ctx.printConditionalEdge());
            this.declareConditionalStart(ctx, conditionName);
            this.edgeCondition(ctx, edgeStart.target().value(), StateGraph.START, conditionName);
        }
        conditionalEdgeCount[0] = 0;
        edges.elements.stream().filter(e -> !Objects.equals(e.sourceId(), StateGraph.START)).forEach(v -> {
            if (v.isParallel()) {
                v.targets().forEach(target -> this.call(ctx, v.sourceId(), target.id(), CallStyle.PARALLEL));
            } else if (v.target().id() != null) {
                this.call(ctx, v.sourceId(), v.target().id(), CallStyle.DEFAULT);
            } else if (v.target().value() != null) {
                conditionalEdgeCount[0] = conditionalEdgeCount[0] + 1;
                String conditionName = String.format("condition%d", conditionalEdgeCount[0]);
                this.edgeCondition(ctx, v.targets().get(0).value(), v.sourceId(), conditionName);
            }
        });
        this.appendFooter(ctx);
        return ctx;
    }

    private <State extends AgentState> void edgeCondition(Context ctx, EdgeCondition<State> condition, String k, String conditionName) {
        this.commentLine(ctx, !ctx.printConditionalEdge());
        this.call(ctx, k, conditionName, CallStyle.CONDITIONAL);
        condition.mappings().forEach((cond, to) -> {
            boolean skipCond = Objects.equals(cond, to);
            this.commentLine(ctx, !ctx.printConditionalEdge());
            if (skipCond) {
                this.call(ctx, conditionName, (String)to, CallStyle.CONDITIONAL);
            } else {
                this.call(ctx, conditionName, (String)to, (String)cond, CallStyle.CONDITIONAL);
            }
            this.commentLine(ctx, ctx.printConditionalEdge());
            if (skipCond) {
                this.call(ctx, k, (String)to, CallStyle.CONDITIONAL);
            } else {
                this.call(ctx, k, (String)to, (String)cond, CallStyle.CONDITIONAL);
            }
        });
    }

    public record Context(StringBuilder sb, String title, boolean printConditionalEdge, boolean isSubGraph) {
        static Builder builder() {
            return new Builder();
        }

        public Optional<String> titleToSnakeCase() {
            return Optional.ofNullable(this.title).map(v -> v.replaceAll("[^a-zA-Z0-9]", "_"));
        }

        @Override
        public String toString() {
            return this.sb.toString();
        }

        public static class Builder {
            String title;
            boolean printConditionalEdge;
            boolean IsSubGraph;

            private Builder() {
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder printConditionalEdge(boolean value) {
                this.printConditionalEdge = value;
                return this;
            }

            public Builder isSubGraph(boolean value) {
                this.IsSubGraph = value;
                return this;
            }

            public Context build() {
                return new Context(new StringBuilder(), this.title, this.printConditionalEdge, this.IsSubGraph);
            }
        }
    }

    public static enum CallStyle {
        DEFAULT,
        START,
        END,
        CONDITIONAL,
        PARALLEL;

    }
}

