/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bsc.langgraph4j.checkpoint.BaseCheckpointSaver;

public class CompileConfig {
    private BaseCheckpointSaver checkpointSaver;
    private Set<String> interruptsBefore = Set.of();
    private Set<String> interruptsAfter = Set.of();
    private boolean releaseThread = false;

    @Deprecated
    public String[] getInterruptBefore() {
        return this.interruptsBefore.toArray(new String[0]);
    }

    @Deprecated
    public String[] getInterruptAfter() {
        return this.interruptsAfter.toArray(new String[0]);
    }

    public Set<String> interruptsBefore() {
        return this.interruptsBefore;
    }

    public Set<String> interruptsAfter() {
        return this.interruptsAfter;
    }

    public Optional<BaseCheckpointSaver> checkpointSaver() {
        return Optional.ofNullable(this.checkpointSaver);
    }

    public boolean releaseThread() {
        return this.releaseThread;
    }

    public static Builder builder() {
        return new Builder(new CompileConfig());
    }

    public static Builder builder(CompileConfig config) {
        return new Builder(config);
    }

    private CompileConfig() {
    }

    private CompileConfig(CompileConfig config) {
        this.checkpointSaver = config.checkpointSaver;
        this.interruptsBefore = config.interruptsBefore;
        this.interruptsAfter = config.interruptsAfter;
        this.releaseThread = config.releaseThread;
    }

    public static class Builder {
        private final CompileConfig config;

        protected Builder(CompileConfig config) {
            this.config = new CompileConfig(config);
        }

        public Builder checkpointSaver(BaseCheckpointSaver checkpointSaver) {
            this.config.checkpointSaver = checkpointSaver;
            return this;
        }

        public Builder interruptBefore(String ... interruptBefore) {
            this.config.interruptsBefore = Set.of(interruptBefore);
            return this;
        }

        public Builder interruptAfter(String ... interruptAfter) {
            this.config.interruptsAfter = Set.of(interruptAfter);
            return this;
        }

        public Builder interruptsBefore(Collection<String> interruptsBefore) {
            this.config.interruptsBefore = interruptsBefore.stream().collect(Collectors.toUnmodifiableSet());
            return this;
        }

        public Builder interruptsAfter(Collection<String> interruptsAfter) {
            this.config.interruptsAfter = interruptsAfter.stream().collect(Collectors.toUnmodifiableSet());
            return this;
        }

        public Builder releaseThread(boolean releaseThread) {
            this.config.releaseThread = releaseThread;
            return this;
        }

        public CompileConfig build() {
            return this.config;
        }
    }
}

