/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.definition.dao;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.tiles.Definition;
import org.apache.tiles.definition.dao.BaseLocaleUrlDefinitionDAO;
import org.apache.tiles.definition.pattern.PatternDefinitionResolver;
import org.apache.tiles.definition.pattern.PatternDefinitionResolverAware;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.ApplicationResource;
import org.apache.tiles.request.locale.LocaleUtil;

public class CachingLocaleUrlDefinitionDAO
extends BaseLocaleUrlDefinitionDAO
implements PatternDefinitionResolverAware<Locale> {
    public static final String CHECK_REFRESH_INIT_PARAMETER = "org.apache.tiles.definition.dao.LocaleUrlDefinitionDAO.CHECK_REFRESH";
    protected Map<Locale, Map<String, Definition>> locale2definitionMap = new HashMap<Locale, Map<String, Definition>>();
    protected boolean checkRefresh = false;
    protected PatternDefinitionResolver<Locale> definitionResolver;

    public CachingLocaleUrlDefinitionDAO(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    @Override
    public void setPatternDefinitionResolver(PatternDefinitionResolver<Locale> definitionResolver) {
        this.definitionResolver = definitionResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Definition getDefinition(String name, Locale customizationKey) {
        Map<String, Definition> definitions;
        Definition retValue = null;
        if (customizationKey == null) {
            customizationKey = Locale.ROOT;
        }
        if ((definitions = this.getDefinitions(customizationKey)) != null && (retValue = definitions.get(name)) == null && (retValue = this.getDefinitionFromResolver(name, customizationKey)) != null) {
            Map<String, Definition> map = definitions;
            synchronized (map) {
                definitions.put(name, retValue);
            }
        }
        return retValue;
    }

    @Override
    public Map<String, Definition> getDefinitions(Locale customizationKey) {
        Map<String, Definition> retValue;
        if (customizationKey == null) {
            customizationKey = Locale.ROOT;
        }
        if ((retValue = this.locale2definitionMap.get(customizationKey)) == null || this.checkRefresh && this.refreshRequired()) {
            retValue = this.checkAndloadDefinitions(customizationKey);
        }
        return retValue;
    }

    public void setCheckRefresh(boolean checkRefresh) {
        this.checkRefresh = checkRefresh;
    }

    protected Definition getDefinitionFromResolver(String name, Locale customizationKey) {
        return this.definitionResolver.resolveDefinition(name, customizationKey);
    }

    protected synchronized Map<String, Definition> checkAndloadDefinitions(Locale customizationKey) {
        if (this.checkRefresh && this.refreshRequired()) {
            this.locale2definitionMap.clear();
        }
        this.loadDefinitions(customizationKey);
        return this.locale2definitionMap.get(customizationKey);
    }

    protected Map<String, Definition> loadDefinitions(Locale customizationKey) {
        Map<String, Definition> localeDefsMap = this.locale2definitionMap.get(customizationKey);
        if (localeDefsMap != null) {
            return localeDefsMap;
        }
        return this.loadDefinitionsFromResources(customizationKey);
    }

    protected Map<String, Definition> loadDefinitionsFromResources(Locale customizationKey) {
        Map<String, Definition> localeDefsMap = this.loadRawDefinitionsFromResources(customizationKey);
        Map<String, Definition> defsMap = this.definitionResolver.storeDefinitionPatterns(this.copyDefinitionMap(localeDefsMap), customizationKey);
        this.locale2definitionMap.put(customizationKey, defsMap);
        return localeDefsMap;
    }

    protected Map<String, Definition> loadRawDefinitionsFromResources(Locale customizationKey) {
        Map<String, Definition> parentDefs;
        Locale parentLocale = LocaleUtil.getParentLocale((Locale)customizationKey);
        LinkedHashMap<String, Definition> localeDefsMap = new LinkedHashMap<String, Definition>();
        if (parentLocale != null && (parentDefs = this.loadRawDefinitionsFromResources(parentLocale)) != null) {
            localeDefsMap.putAll(parentDefs);
        }
        for (ApplicationResource resource : this.sources) {
            Map<String, Definition> defsMap;
            ApplicationResource newResource = this.applicationContext.getResource(resource, customizationKey);
            if (newResource == null || (defsMap = this.loadDefinitionsFromResource(newResource)) == null) continue;
            localeDefsMap.putAll(defsMap);
        }
        return localeDefsMap;
    }

    protected Map<String, Definition> loadParentDefinitions(Locale parentLocale) {
        return this.loadDefinitions(parentLocale);
    }

    protected Map<String, Definition> copyDefinitionMap(Map<String, Definition> localeDefsMap) {
        return localeDefsMap;
    }
}

