/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.sitemesh;

import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.profiling.UtilTimerStack;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.sitemesh.TemplatePageFilter;
import org.apache.struts2.views.freemarker.FreemarkerManager;

public class FreeMarkerPageFilter
extends TemplatePageFilter {
    private static final Log LOG = LogFactory.getLog(FreeMarkerPageFilter.class);
    private static FreemarkerManager freemarkerManager;

    @Inject(required=false)
    public static void setFreemarkerManager(FreemarkerManager mgr) {
        freemarkerManager = mgr;
    }

    protected void applyDecorator(Page page, Decorator decorator, HttpServletRequest req, HttpServletResponse res, ServletContext servletContext, ActionContext ctx) throws ServletException, IOException {
        String timerKey = "FreemarkerPageFilter_applyDecorator: ";
        if (freemarkerManager == null) {
            throw new ServletException("Missing freemarker dependency");
        }
        try {
            UtilTimerStack.push((String)timerKey);
            Configuration config = freemarkerManager.getConfiguration(servletContext);
            Template template = config.getTemplate(decorator.getPage(), this.getLocale(ctx.getActionInvocation(), config));
            SimpleHash model = freemarkerManager.buildTemplateModel(ctx.getValueStack(), null, servletContext, req, res, config.getObjectWrapper());
            model.put("page", (Object)page);
            if (page instanceof HTMLPage) {
                HTMLPage htmlPage = (HTMLPage)page;
                model.put("head", (Object)htmlPage.getHead());
            }
            model.put("title", (Object)page.getTitle());
            model.put("body", (Object)page.getBody());
            model.put("page.properties", (Object)new SimpleHash(page.getProperties()));
            template.process((Object)model, (Writer)res.getWriter());
        }
        catch (Exception e) {
            String msg = "Error applying decorator: " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new ServletException(msg, (Throwable)e);
        }
        finally {
            UtilTimerStack.pop((String)timerKey);
        }
    }

    protected Locale getLocale(ActionInvocation invocation, Configuration configuration) {
        if (invocation.getAction() instanceof LocaleProvider) {
            return ((LocaleProvider)invocation.getAction()).getLocale();
        }
        return configuration.getLocale();
    }
}

