/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Random;
import java.util.concurrent.ConcurrentMap;
import javax.management.MBeanServer;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.util.KnownSizeEstimation;
import org.apache.spark.util.SizeEstimator;
import org.apache.spark.util.collection.OpenHashSet;
import org.apache.spark.util.collection.OpenHashSet$mcI$sp;
import org.slf4j.Logger;
import org.spark-project.guava.collect.MapMaker;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.TraitSetter;

@DeveloperApi
public final class SizeEstimator$
implements Logging {
    public static final SizeEstimator$ MODULE$;
    private final int BYTE_SIZE;
    private final int BOOLEAN_SIZE;
    private final int CHAR_SIZE;
    private final int SHORT_SIZE;
    private final int INT_SIZE;
    private final int LONG_SIZE;
    private final int FLOAT_SIZE;
    private final int DOUBLE_SIZE;
    private final List<Object> fieldSizes;
    private final int ALIGN_SIZE;
    private final ConcurrentMap<Class<?>, SizeEstimator.ClassInfo> classInfos;
    private boolean is64bit;
    private boolean isCompressedOops;
    private int org$apache$spark$util$SizeEstimator$$pointerSize;
    private int objectSize;
    private final int ARRAY_SIZE_FOR_SAMPLING;
    private final int ARRAY_SAMPLE_SIZE;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new SizeEstimator$();
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public long estimate(Object obj) {
        return this.org$apache$spark$util$SizeEstimator$$estimate(obj, new IdentityHashMap<Object, Object>());
    }

    private int BYTE_SIZE() {
        return this.BYTE_SIZE;
    }

    private int BOOLEAN_SIZE() {
        return this.BOOLEAN_SIZE;
    }

    private int CHAR_SIZE() {
        return this.CHAR_SIZE;
    }

    private int SHORT_SIZE() {
        return this.SHORT_SIZE;
    }

    private int INT_SIZE() {
        return this.INT_SIZE;
    }

    private int LONG_SIZE() {
        return this.LONG_SIZE;
    }

    private int FLOAT_SIZE() {
        return this.FLOAT_SIZE;
    }

    private int DOUBLE_SIZE() {
        return this.DOUBLE_SIZE;
    }

    private List<Object> fieldSizes() {
        return this.fieldSizes;
    }

    private int ALIGN_SIZE() {
        return this.ALIGN_SIZE;
    }

    private ConcurrentMap<Class<?>, SizeEstimator.ClassInfo> classInfos() {
        return this.classInfos;
    }

    private boolean is64bit() {
        return this.is64bit;
    }

    private void is64bit_$eq(boolean x$1) {
        this.is64bit = x$1;
    }

    private boolean isCompressedOops() {
        return this.isCompressedOops;
    }

    private void isCompressedOops_$eq(boolean x$1) {
        this.isCompressedOops = x$1;
    }

    public int org$apache$spark$util$SizeEstimator$$pointerSize() {
        return this.org$apache$spark$util$SizeEstimator$$pointerSize;
    }

    private void org$apache$spark$util$SizeEstimator$$pointerSize_$eq(int x$1) {
        this.org$apache$spark$util$SizeEstimator$$pointerSize = x$1;
    }

    private int objectSize() {
        return this.objectSize;
    }

    private void objectSize_$eq(int x$1) {
        this.objectSize = x$1;
    }

    private void initialize() {
        String arch = System.getProperty("os.arch");
        this.is64bit_$eq(arch.contains("64") || arch.contains("s390x"));
        this.isCompressedOops_$eq(this.getIsCompressedOops());
        this.objectSize_$eq(this.is64bit() ? (this.isCompressedOops() ? 12 : 16) : 8);
        this.org$apache$spark$util$SizeEstimator$$pointerSize_$eq(this.is64bit() && !this.isCompressedOops() ? 8 : 4);
        this.classInfos().clear();
        this.classInfos().put(Object.class, new SizeEstimator.ClassInfo(this.objectSize(), (List<Field>)Nil$.MODULE$));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean getIsCompressedOops() {
        if (System.getProperty("spark.test.useCompressedOops") != null) return new StringOps(Predef$.MODULE$.augmentString(System.getProperty("spark.test.useCompressedOops"))).toBoolean();
        if (System.getProperty("java.vendor").contains("IBM")) {
            return System.getProperty("java.vm.info").contains("Compressed Ref");
        }
        try {
            String hotSpotMBeanName = "com.sun.management:type=HotSpotDiagnostic";
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            Class<?> hotSpotMBeanClass = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            Method getVMMethod = hotSpotMBeanClass.getDeclaredMethod("getVMOption", Class.forName("java.lang.String"));
            Object bean = ManagementFactory.newPlatformMXBeanProxy(server, hotSpotMBeanName, hotSpotMBeanClass);
            return getVMMethod.invoke(bean, "UseCompressedOops").toString().contains("true");
        }
        catch (Exception exception2) {
            boolean guess = Runtime.getRuntime().maxMemory() < 0x800000000L;
            String guessInWords = guess ? "yes" : "not";
            this.logWarning((Function0<String>)new Serializable(guessInWords){
                public static final long serialVersionUID = 0L;
                private final String guessInWords$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Failed to check whether UseCompressedOops is set; assuming ").append((Object)this.guessInWords$1).toString();
                }
                {
                    this.guessInWords$1 = guessInWords$1;
                }
            });
            return guess;
        }
    }

    /*
     * WARNING - void declaration
     */
    public long org$apache$spark$util$SizeEstimator$$estimate(Object obj, IdentityHashMap<Object, Object> visited) {
        SizeEstimator.SearchState state = new SizeEstimator.SearchState(visited);
        state.enqueue(obj);
        while (!state.isFinished()) {
            void var3_3;
            this.visitSingleObject(var3_3.dequeue(), (SizeEstimator.SearchState)var3_3);
        }
        return state.size();
    }

    private void visitSingleObject(Object obj, SizeEstimator.SearchState state) {
        Class<?> cls = obj.getClass();
        if (cls.isArray()) {
            this.visitArray(obj, cls, state);
        } else if (!(obj instanceof ClassLoader) && !(obj instanceof Class)) {
            Object object = obj;
            if (object instanceof KnownSizeEstimation) {
                KnownSizeEstimation knownSizeEstimation = (KnownSizeEstimation)object;
                state.size_$eq(state.size() + knownSizeEstimation.estimatedSize());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                SizeEstimator.ClassInfo classInfo = this.getClassInfo(cls);
                state.size_$eq(state.size() + this.alignSize(classInfo.shellSize()));
                classInfo.pointerFields().foreach((Function1)new Serializable(obj, state){
                    public static final long serialVersionUID = 0L;
                    private final Object obj$1;
                    private final SizeEstimator.SearchState state$1;

                    public final void apply(Field field) {
                        this.state$1.enqueue(field.get(this.obj$1));
                    }
                    {
                        this.obj$1 = obj$1;
                        this.state$1 = state$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private int ARRAY_SIZE_FOR_SAMPLING() {
        return this.ARRAY_SIZE_FOR_SAMPLING;
    }

    private int ARRAY_SAMPLE_SIZE() {
        return this.ARRAY_SAMPLE_SIZE;
    }

    private void visitArray(Object array, Class<?> arrayClass, SizeEstimator.SearchState state) {
        int length = ScalaRunTime$.MODULE$.array_length(array);
        Class<?> elementClass = arrayClass.getComponentType();
        long arrSize = this.alignSize(this.objectSize() + this.INT_SIZE());
        if (elementClass.isPrimitive()) {
            state.size_$eq(state.size() + (arrSize += this.alignSize((long)length * (long)this.org$apache$spark$util$SizeEstimator$$primitiveSize(elementClass))));
        } else {
            state.size_$eq(state.size() + (arrSize += this.alignSize((long)length * (long)this.org$apache$spark$util$SizeEstimator$$pointerSize())));
            if (length <= this.ARRAY_SIZE_FOR_SAMPLING()) {
                for (int arrayIndex = 0; arrayIndex < length; ++arrayIndex) {
                    state.enqueue(ScalaRunTime$.MODULE$.array_apply(array, arrayIndex));
                }
            } else {
                Random rand = new Random(42L);
                OpenHashSet$mcI$sp drawn = new OpenHashSet$mcI$sp(2 * this.ARRAY_SAMPLE_SIZE(), (ClassTag<Object>)ClassTag$.MODULE$.Int());
                long s1 = this.sampleArray(array, state, rand, drawn, length);
                long s2 = this.sampleArray(array, state, rand, drawn, length);
                long size = package$.MODULE$.min(s1, s2);
                state.size_$eq(state.size() + (package$.MODULE$.max(s1, s2) + size * (long)((length - this.ARRAY_SAMPLE_SIZE()) / this.ARRAY_SAMPLE_SIZE())));
            }
        }
    }

    private long sampleArray(Object array, SizeEstimator.SearchState state, Random rand, OpenHashSet<Object> drawn, int length) {
        LongRef size = new LongRef(0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.ARRAY_SAMPLE_SIZE()).foreach$mVc$sp((Function1)new Serializable(array, state, rand, drawn, length, size){
            public static final long serialVersionUID = 0L;
            private final Object array$1;
            private final SizeEstimator.SearchState state$2;
            private final Random rand$1;
            private final OpenHashSet drawn$1;
            private final int length$1;
            private final LongRef size$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int index = 0;
                while (this.drawn$1.contains$mcI$sp(index = this.rand$1.nextInt(this.length$1))) {
                }
                this.drawn$1.add$mcI$sp(index);
                Object obj = ScalaRunTime$.MODULE$.array_apply(this.array$1, index);
                if (obj != null) {
                    this.size$1.elem += SizeEstimator$.MODULE$.org$apache$spark$util$SizeEstimator$$estimate(obj, this.state$2.visited());
                }
            }
            {
                this.array$1 = array$1;
                this.state$2 = state$2;
                this.rand$1 = rand$1;
                this.drawn$1 = drawn$1;
                this.length$1 = length$1;
                this.size$1 = size$1;
            }
        });
        return size.elem;
    }

    public int org$apache$spark$util$SizeEstimator$$primitiveSize(Class<?> cls) {
        block10: {
            int n;
            block3: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            Class<?> clazz = cls;
                                            Class<Byte> clazz2 = Byte.TYPE;
                                            if (clazz != null ? !clazz.equals(clazz2) : clazz2 != null) break block2;
                                            n = this.BYTE_SIZE();
                                            break block3;
                                        }
                                        Class<?> clazz = cls;
                                        Class<Boolean> clazz3 = Boolean.TYPE;
                                        if (clazz != null ? !clazz.equals(clazz3) : clazz3 != null) break block4;
                                        n = this.BOOLEAN_SIZE();
                                        break block3;
                                    }
                                    Class<?> clazz = cls;
                                    Class<Character> clazz4 = Character.TYPE;
                                    if (clazz != null ? !clazz.equals(clazz4) : clazz4 != null) break block5;
                                    n = this.CHAR_SIZE();
                                    break block3;
                                }
                                Class<?> clazz = cls;
                                Class<Short> clazz5 = Short.TYPE;
                                if (clazz != null ? !clazz.equals(clazz5) : clazz5 != null) break block6;
                                n = this.SHORT_SIZE();
                                break block3;
                            }
                            Class<?> clazz = cls;
                            Class<Integer> clazz6 = Integer.TYPE;
                            if (clazz != null ? !clazz.equals(clazz6) : clazz6 != null) break block7;
                            n = this.INT_SIZE();
                            break block3;
                        }
                        Class<?> clazz = cls;
                        Class<Long> clazz7 = Long.TYPE;
                        if (clazz != null ? !clazz.equals(clazz7) : clazz7 != null) break block8;
                        n = this.LONG_SIZE();
                        break block3;
                    }
                    Class<?> clazz = cls;
                    Class<Float> clazz8 = Float.TYPE;
                    if (clazz != null ? !clazz.equals(clazz8) : clazz8 != null) break block9;
                    n = this.FLOAT_SIZE();
                    break block3;
                }
                Class<?> clazz = cls;
                Class<Double> clazz9 = Double.TYPE;
                if (clazz != null ? !clazz.equals(clazz9) : clazz9 != null) break block10;
                n = this.DOUBLE_SIZE();
            }
            return n;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Non-primitive class ").append(cls).append((Object)" passed to primitiveSize()").toString());
    }

    /*
     * WARNING - void declaration
     */
    private SizeEstimator.ClassInfo getClassInfo(Class<?> cls) {
        void var2_2;
        SizeEstimator.ClassInfo info = (SizeEstimator.ClassInfo)this.classInfos().get(cls);
        if (info == null) {
            SizeEstimator.ClassInfo parent = this.getClassInfo(cls.getSuperclass());
            LongRef shellSize = new LongRef(parent.shellSize());
            ObjectRef pointerFields = new ObjectRef(parent.pointerFields());
            int[] sizeCount = (int[])Array$.MODULE$.fill(BoxesRunTime.unboxToInt((Object)this.fieldSizes().max((Ordering)Ordering.Int$.MODULE$)) + 1, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return 0;
                }
            }, ClassTag$.MODULE$.Int());
            Predef$.MODULE$.refArrayOps((Object[])cls.getDeclaredFields()).foreach((Function1)new Serializable(pointerFields, sizeCount){
                public static final long serialVersionUID = 0L;
                private final ObjectRef pointerFields$1;
                private final int[] sizeCount$1;

                public final void apply(Field field) {
                    if (!Modifier.isStatic(field.getModifiers())) {
                        Class<?> fieldClass = field.getType();
                        if (fieldClass.isPrimitive()) {
                            int n = SizeEstimator$.MODULE$.org$apache$spark$util$SizeEstimator$$primitiveSize(fieldClass);
                            this.sizeCount$1[n] = this.sizeCount$1[n] + 1;
                        } else {
                            field.setAccessible(true);
                            int n = SizeEstimator$.MODULE$.org$apache$spark$util$SizeEstimator$$pointerSize();
                            this.sizeCount$1[n] = this.sizeCount$1[n] + 1;
                            Field field2 = field;
                            this.pointerFields$1.elem = ((List)this.pointerFields$1.elem).$colon$colon((Object)field2);
                        }
                    }
                }
                {
                    this.pointerFields$1 = pointerFields$1;
                    this.sizeCount$1 = sizeCount$1;
                }
            });
            LongRef alignedSize = new LongRef(shellSize.elem);
            this.fieldSizes().withFilter((Function1)new Serializable(sizeCount){
                public static final long serialVersionUID = 0L;
                private final int[] sizeCount$1;

                public final boolean apply(int size) {
                    return this.apply$mcZI$sp(size);
                }

                public boolean apply$mcZI$sp(int size) {
                    return this.sizeCount$1[size] > 0;
                }
                {
                    this.sizeCount$1 = sizeCount$1;
                }
            }).foreach((Function1)new Serializable(shellSize, sizeCount, alignedSize){
                public static final long serialVersionUID = 0L;
                private final LongRef shellSize$1;
                private final int[] sizeCount$1;
                private final LongRef alignedSize$1;

                public final void apply(int size) {
                    this.apply$mcVI$sp(size);
                }

                public void apply$mcVI$sp(int size) {
                    long count2 = this.sizeCount$1[size];
                    this.alignedSize$1.elem = package$.MODULE$.max(this.alignedSize$1.elem, SizeEstimator$.MODULE$.org$apache$spark$util$SizeEstimator$$alignSizeUp(this.shellSize$1.elem, size) + (long)size * count2);
                    this.shellSize$1.elem += (long)size * count2;
                }
                {
                    this.shellSize$1 = shellSize$1;
                    this.sizeCount$1 = sizeCount$1;
                    this.alignedSize$1 = alignedSize$1;
                }
            });
            shellSize.elem = this.org$apache$spark$util$SizeEstimator$$alignSizeUp(alignedSize.elem, this.org$apache$spark$util$SizeEstimator$$pointerSize());
            SizeEstimator.ClassInfo newInfo = new SizeEstimator.ClassInfo(shellSize.elem, (List<Field>)((List)pointerFields.elem));
            this.classInfos().put(cls, newInfo);
            return newInfo;
        }
        return var2_2;
    }

    private long alignSize(long size) {
        return this.org$apache$spark$util$SizeEstimator$$alignSizeUp(size, this.ALIGN_SIZE());
    }

    public long org$apache$spark$util$SizeEstimator$$alignSizeUp(long size, int alignSize) {
        return size + (long)alignSize - 1L & (long)(~(alignSize - 1));
    }

    private SizeEstimator$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.BYTE_SIZE = 1;
        this.BOOLEAN_SIZE = 1;
        this.CHAR_SIZE = 2;
        this.SHORT_SIZE = 2;
        this.INT_SIZE = 4;
        this.LONG_SIZE = 8;
        this.FLOAT_SIZE = 4;
        this.DOUBLE_SIZE = 8;
        this.fieldSizes = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{8, 4, 2, 1}));
        this.ALIGN_SIZE = 8;
        this.classInfos = new MapMaker().weakKeys().makeMap();
        this.is64bit = false;
        this.isCompressedOops = false;
        this.org$apache$spark$util$SizeEstimator$$pointerSize = 4;
        this.objectSize = 8;
        this.initialize();
        this.ARRAY_SIZE_FOR_SAMPLING = 400;
        this.ARRAY_SAMPLE_SIZE = 100;
    }
}

