/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui;

import java.net.InetSocketAddress;
import java.net.URL;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.ui.JettyUtils;
import org.apache.spark.ui.JettyUtils$;
import org.apache.spark.ui.JettyUtils$ServletParams$;
import org.apache.spark.ui.ServerInfo;
import org.apache.spark.util.Utils$;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.slf4j.Logger;
import org.spark-project.jetty.server.Connector;
import org.spark-project.jetty.server.Handler;
import org.spark-project.jetty.server.Server;
import org.spark-project.jetty.server.handler.ContextHandlerCollection;
import org.spark-project.jetty.server.handler.ErrorHandler;
import org.spark-project.jetty.server.handler.GzipHandler;
import org.spark-project.jetty.servlet.DefaultServlet;
import org.spark-project.jetty.servlet.FilterHolder;
import org.spark-project.jetty.servlet.ServletContextHandler;
import org.spark-project.jetty.servlet.ServletHolder;
import org.spark-project.jetty.util.thread.QueuedThreadPool;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;
import scala.xml.Node;

public final class JettyUtils$
implements Logging {
    public static final JettyUtils$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new JettyUtils$();
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public JettyUtils.ServletParams<JsonAST.JValue> jsonResponderToServlet(Function1<HttpServletRequest, JsonAST.JValue> responder) {
        return new JettyUtils.ServletParams<JsonAST.JValue>(responder, "text/json", (Function1<JsonAST.JValue, String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(JsonAST.JValue in) {
                return JsonMethods$.MODULE$.pretty(JsonMethods$.MODULE$.render(in));
            }
        }, (Function1<JsonAST.JValue, Object>)Predef$.MODULE$.conforms());
    }

    public JettyUtils.ServletParams<Seq<Node>> htmlResponderToServlet(Function1<HttpServletRequest, Seq<Node>> responder) {
        return new JettyUtils.ServletParams<Seq<Node>>(responder, "text/html", (Function1<Seq<Node>, String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Seq<Node> in) {
                return new StringBuilder().append((Object)"<!DOCTYPE html>").append((Object)in.toString()).toString();
            }
        }, (Function1<Seq<Node>, Object>)Predef$.MODULE$.conforms());
    }

    public JettyUtils.ServletParams<String> textResponderToServlet(Function1<HttpServletRequest, String> responder) {
        return new JettyUtils.ServletParams<Object>((Function1<HttpServletRequest, Object>)responder, "text/plain", JettyUtils$ServletParams$.MODULE$.$lessinit$greater$default$3(), (Function1<Object, Object>)Predef$.MODULE$.conforms());
    }

    public <T> HttpServlet createServlet(JettyUtils.ServletParams<T> servletParams, SecurityManager securityMgr, SparkConf conf, Function1<T, Object> evidence$2) {
        Option<String> allowFramingFrom = conf.getOption("spark.ui.allowFramingFrom");
        String xFrameOptionsValue = (String)allowFramingFrom.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String uri) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ALLOW-FROM ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri}));
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "SAMEORIGIN";
            }
        });
        return new HttpServlet(servletParams, securityMgr, xFrameOptionsValue){
            private final JettyUtils.ServletParams servletParams$1;
            private final SecurityManager securityMgr$1;
            private final String xFrameOptionsValue$1;

            public void doGet(HttpServletRequest request, HttpServletResponse response) {
                try {
                    if (this.securityMgr$1.checkUIViewPermissions(request.getRemoteUser())) {
                        response.setContentType(new StringOps(Predef$.MODULE$.augmentString("%s;charset=utf-8")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.servletParams$1.contentType()})));
                        response.setStatus(200);
                        Object result = this.servletParams$1.responder().apply((Object)request);
                        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                        response.setHeader("X-Frame-Options", this.xFrameOptionsValue$1);
                        response.getWriter().println((String)this.servletParams$1.extractFn().apply(result));
                    } else {
                        response.setStatus(401);
                        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                        response.sendError(401, "User is not authorized to access this page.");
                    }
                }
                catch (Exception exception2) {
                    JettyUtils$.MODULE$.logWarning((Function0<String>)new Serializable(this, request, exception2){
                        public static final long serialVersionUID = 0L;
                        private final HttpServletRequest request$1;
                        private final Exception e$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GET ", " failed: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.request$1.getRequestURI(), this.e$1}));
                        }
                        {
                            this.request$1 = request$1;
                            this.e$1 = e$1;
                        }
                    }, exception2);
                    throw exception2;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    response.sendError(400, illegalArgumentException.getMessage());
                }
            }

            public void doTrace(HttpServletRequest req, HttpServletResponse res) {
                res.sendError(405);
            }
            {
                this.servletParams$1 = servletParams$1;
                this.securityMgr$1 = securityMgr$1;
                this.xFrameOptionsValue$1 = xFrameOptionsValue$1;
            }
        };
    }

    public <T> ServletContextHandler createServletHandler(String path, JettyUtils.ServletParams<T> servletParams, SecurityManager securityMgr, SparkConf conf, String basePath, Function1<T, Object> evidence$3) {
        return this.createServletHandler(path, this.createServlet(servletParams, securityMgr, conf, evidence$3), basePath);
    }

    /*
     * Unable to fully structure code
     */
    public ServletContextHandler createServletHandler(String path, HttpServlet servlet, String basePath) {
        v0 = basePath;
        var4_4 = "";
        if (v0 != null ? v0.equals(var4_4) == false : var4_4 != null) ** GOTO lbl-1000
        v1 = path;
        var5_5 = "/";
        if (!(v1 != null ? v1.equals(var5_5) == false : var5_5 != null)) {
            v2 = path;
        } else lbl-1000:
        // 2 sources

        {
            v2 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)basePath).append((Object)path).toString())).stripSuffix("/");
        }
        prefixedPath = v2;
        contextHandler = new ServletContextHandler();
        holder = new ServletHolder((Servlet)servlet);
        contextHandler.setContextPath(prefixedPath);
        contextHandler.addServlet(holder, "/");
        return contextHandler;
    }

    public <T> String createServletHandler$default$5() {
        return "";
    }

    public ServletContextHandler createRedirectHandler(String srcPath, String destPath, Function1<HttpServletRequest, BoxedUnit> beforeRedirect, String basePath, Set<String> httpMethods) {
        String prefixedDestPath = new StringBuilder().append((Object)basePath).append((Object)destPath).toString();
        HttpServlet servlet = new HttpServlet(beforeRedirect, httpMethods, prefixedDestPath){
            private final Function1 beforeRedirect$1;
            private final Set httpMethods$1;
            private final String prefixedDestPath$1;

            public void doGet(HttpServletRequest request, HttpServletResponse response) {
                if (this.httpMethods$1.contains((Object)"GET")) {
                    this.doRequest(request, response);
                } else {
                    response.sendError(405);
                }
            }

            public void doPost(HttpServletRequest request, HttpServletResponse response) {
                if (this.httpMethods$1.contains((Object)"POST")) {
                    this.doRequest(request, response);
                } else {
                    response.sendError(405);
                }
            }

            private void doRequest(HttpServletRequest request, HttpServletResponse response) {
                this.beforeRedirect$1.apply((Object)request);
                String newUrl = new URL(new URL(request.getRequestURL().toString()), this.prefixedDestPath$1).toString();
                response.sendRedirect(newUrl);
            }

            public void doTrace(HttpServletRequest req, HttpServletResponse res) {
                res.sendError(405);
            }
            {
                this.beforeRedirect$1 = beforeRedirect$1;
                this.httpMethods$1 = httpMethods$1;
                this.prefixedDestPath$1 = prefixedDestPath$1;
            }
        };
        return this.createServletHandler(srcPath, servlet, basePath);
    }

    public Function1<HttpServletRequest, BoxedUnit> createRedirectHandler$default$3() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(HttpServletRequest x) {
            }
        };
    }

    public String createRedirectHandler$default$4() {
        return "";
    }

    public Set<String> createRedirectHandler$default$5() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GET"}));
    }

    /*
     * WARNING - void declaration
     */
    public ServletContextHandler createStaticHandler(String resourceBase, String path) {
        ServletContextHandler contextHandler = new ServletContextHandler();
        contextHandler.setInitParameter("org.spark-project.jetty.servlet.Default.gzip", "false");
        DefaultServlet staticHandler = new DefaultServlet();
        ServletHolder holder = new ServletHolder((Servlet)staticHandler);
        Option option = Option$.MODULE$.apply((Object)Utils$.MODULE$.getSparkClassLoader().getResource(resourceBase));
        if (option instanceof Some) {
            void var3_3;
            Some some = (Some)option;
            URL res = (URL)some.x();
            holder.setInitParameter("resourceBase", res.toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            contextHandler.setContextPath(path);
            contextHandler.addServlet(holder, "/");
            return var3_3;
        }
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new Exception(new StringBuilder().append((Object)"Could not find resource path for Web UI: ").append((Object)resourceBase).toString());
        }
        throw new MatchError((Object)option);
    }

    public void addFilters(Seq<ServletContextHandler> handlers, SparkConf conf) {
        String[] filters = (String[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(conf.get("spark.ui.filters", ""))).split(',')).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return x$1.trim();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Predef$.MODULE$.refArrayOps((Object[])filters).foreach((Function1)new Serializable(handlers, conf){
            public static final long serialVersionUID = 0L;
            private final Seq handlers$1;
            private final SparkConf conf$1;

            public final void apply(String x0$1) {
                String string = x0$1;
                if (string != null) {
                    BoxedUnit boxedUnit;
                    String string2 = string;
                    if (string2.isEmpty()) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        JettyUtils$.MODULE$.logInfo((Function0<String>)new Serializable(this, string2){
                            public static final long serialVersionUID = 0L;
                            private final String x2$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Adding filter: ").append((Object)this.x2$1).toString();
                            }
                            {
                                this.x2$1 = x2$1;
                            }
                        });
                        FilterHolder holder = new FilterHolder();
                        holder.setClassName(string2);
                        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(this.conf$1.get(new StringBuilder().append((Object)"spark.").append((Object)string2).append((Object)".params").toString(), ""))).split(',')).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(String x$2) {
                                return x$2.trim();
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().foreach((Function1)new Serializable(this, holder){
                            public static final long serialVersionUID = 0L;
                            private final FilterHolder holder$1;

                            public final void apply(String param) {
                                String[] parts;
                                if (!param.isEmpty() && (parts = param.split("=")).length == 2) {
                                    this.holder$1.setInitParameter(parts[0], parts[1]);
                                }
                            }
                            {
                                this.holder$1 = holder$1;
                            }
                        });
                        String prefix = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark.", ".param."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string2}));
                        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.conf$1.getAll()).filter((Function1)new Serializable(this, prefix){
                            public static final long serialVersionUID = 0L;
                            private final String prefix$1;

                            public final boolean apply(Tuple2<String, String> x0$2) {
                                Tuple2<String, String> tuple2 = x0$2;
                                if (tuple2 != null) {
                                    String k = (String)tuple2._1();
                                    boolean bl = k.length() > this.prefix$1.length() && k.startsWith(this.prefix$1);
                                    return bl;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.prefix$1 = prefix$1;
                            }
                        })).foreach((Function1)new Serializable(this, holder, prefix){
                            public static final long serialVersionUID = 0L;
                            private final FilterHolder holder$1;
                            private final String prefix$1;

                            public final void apply(Tuple2<String, String> x0$3) {
                                Tuple2<String, String> tuple2 = x0$3;
                                if (tuple2 != null) {
                                    String k = (String)tuple2._1();
                                    String v = (String)tuple2._2();
                                    this.holder$1.setInitParameter(k.substring(this.prefix$1.length()), v);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.holder$1 = holder$1;
                                this.prefix$1 = prefix$1;
                            }
                        });
                        EnumSet<DispatcherType> enumDispatcher = EnumSet.of(DispatcherType.ASYNC, DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST);
                        this.handlers$1.foreach((Function1)new Serializable(this, holder, enumDispatcher){
                            public static final long serialVersionUID = 0L;
                            private final FilterHolder holder$1;
                            private final EnumSet enumDispatcher$1;

                            public final void apply(ServletContextHandler x0$4) {
                                ServletContextHandler servletContextHandler = x0$4;
                                servletContextHandler.addFilter(this.holder$1, "/*", (EnumSet<DispatcherType>)this.enumDispatcher$1);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            {
                                this.holder$1 = holder$1;
                                this.enumDispatcher$1 = enumDispatcher$1;
                            }
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError((Object)string);
            }
            {
                this.handlers$1 = handlers$1;
                this.conf$1 = conf$1;
            }
        });
    }

    public ServerInfo startJettyServer(String hostName, int port, Seq<ServletContextHandler> handlers, SparkConf conf, String serverName) {
        this.addFilters(handlers, conf);
        ContextHandlerCollection collection = new ContextHandlerCollection();
        Seq gzipHandlers = (Seq)handlers.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final GzipHandler apply(ServletContextHandler h) {
                void var2_2;
                GzipHandler gzipHandler = new GzipHandler();
                gzipHandler.setHandler(h);
                return var2_2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        collection.setHandlers((Handler[])gzipHandlers.toArray(ClassTag$.MODULE$.apply(Handler.class)));
        Tuple2 tuple2 = Utils$.MODULE$.startServiceOnPort(port, new anonfun.5(hostName, collection), conf, serverName);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Server server = (Server)tuple2._1();
            int boundPort2 = tuple2._2$mcI$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)server, (Object)BoxesRunTime.boxToInteger((int)boundPort2));
            Server server2 = (Server)tuple23._1();
            int boundPort3 = tuple23._2$mcI$sp();
            return new ServerInfo(server2, boundPort3, collection);
        }
        throw new MatchError(tuple2);
    }

    public String startJettyServer$default$5() {
        return "";
    }

    public final Tuple2 org$apache$spark$ui$JettyUtils$$connect$1(int currentPort, String hostName$1, ContextHandlerCollection collection$1) {
        Server server = new Server(new InetSocketAddress(hostName$1, currentPort));
        QueuedThreadPool pool = new QueuedThreadPool();
        pool.setDaemon(true);
        server.setThreadPool(pool);
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setShowStacks(true);
        server.addBean(errorHandler);
        server.setHandler(collection$1);
        try {
            server.start();
            return new Tuple2((Object)server, (Object)BoxesRunTime.boxToInteger((int)((Connector)Predef$.MODULE$.refArrayOps((Object[])server.getConnectors()).head()).getLocalPort()));
        }
        catch (Exception exception2) {
            server.stop();
            pool.stop();
            throw exception2;
        }
    }

    private JettyUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

