/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.sort;

import java.util.Comparator;
import org.apache.spark.memory.MemoryConsumer;
import org.apache.spark.shuffle.sort.PackedRecordPointer;
import org.apache.spark.shuffle.sort.ShuffleSortDataFormat;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.LongArray;
import org.apache.spark.util.collection.Sorter;

final class ShuffleInMemorySorter {
    private final Sorter<PackedRecordPointer, LongArray> sorter;
    private static final SortComparator SORT_COMPARATOR = new SortComparator();
    private final MemoryConsumer consumer;
    private LongArray array;
    private int pos = 0;

    public ShuffleInMemorySorter(MemoryConsumer consumer, int initialSize) {
        this.consumer = consumer;
        assert (initialSize > 0);
        this.array = consumer.allocateArray(initialSize);
        this.sorter = new Sorter<PackedRecordPointer, LongArray>(ShuffleSortDataFormat.INSTANCE);
    }

    public void free() {
        if (this.array != null) {
            this.consumer.freeArray(this.array);
            this.array = null;
        }
    }

    public int numRecords() {
        return this.pos;
    }

    public void reset() {
        this.pos = 0;
    }

    public void expandPointerArray(LongArray newArray) {
        assert (newArray.size() > this.array.size());
        Platform.copyMemory((Object)this.array.getBaseObject(), (long)this.array.getBaseOffset(), (Object)newArray.getBaseObject(), (long)newArray.getBaseOffset(), (long)(this.array.size() * 8L));
        this.consumer.freeArray(this.array);
        this.array = newArray;
    }

    public boolean hasSpaceForAnotherRecord() {
        return (long)this.pos < this.array.size();
    }

    public long getMemoryUsage() {
        return this.array.size() * 8L;
    }

    public void insertRecord(long recordPointer, int partitionId) {
        if (!this.hasSpaceForAnotherRecord()) {
            this.expandPointerArray(this.consumer.allocateArray(this.array.size() * 2L));
        }
        this.array.set(this.pos, PackedRecordPointer.packPointer(recordPointer, partitionId));
        ++this.pos;
    }

    public ShuffleSorterIterator getSortedIterator() {
        this.sorter.sort(this.array, 0, this.pos, SORT_COMPARATOR);
        return new ShuffleSorterIterator(this.pos, this.array);
    }

    public static final class ShuffleSorterIterator {
        private final LongArray pointerArray;
        private final int numRecords;
        final PackedRecordPointer packedRecordPointer = new PackedRecordPointer();
        private int position = 0;

        public ShuffleSorterIterator(int numRecords, LongArray pointerArray) {
            this.numRecords = numRecords;
            this.pointerArray = pointerArray;
        }

        public boolean hasNext() {
            return this.position < this.numRecords;
        }

        public void loadNext() {
            this.packedRecordPointer.set(this.pointerArray.get(this.position));
            ++this.position;
        }
    }

    private static final class SortComparator
    implements Comparator<PackedRecordPointer> {
        private SortComparator() {
        }

        @Override
        public int compare(PackedRecordPointer left, PackedRecordPointer right) {
            return left.getPartitionId() - right.getPartitionId();
        }
    }
}

