/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.network.buffer.FileSegmentManagedBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.shuffle.IndexShuffleBlockResolver$;
import org.apache.spark.shuffle.ShuffleBlockResolver;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.storage.ShuffleDataBlockId;
import org.apache.spark.storage.ShuffleIndexBlockId;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.spark-project.guava.io.ByteStreams;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c!B\u0001\u0003\u0001\u0011Q!!G%oI\u0016D8\u000b[;gM2,'\t\\8dWJ+7o\u001c7wKJT!a\u0001\u0003\u0002\u000fMDWO\u001a4mK*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xm\u0005\u0003\u0001\u0017E)\u0002C\u0001\u0007\u0010\u001b\u0005i!\"\u0001\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Ai!AB!osJ+g\r\u0005\u0002\u0013'5\t!!\u0003\u0002\u0015\u0005\t!2\u000b[;gM2,'\t\\8dWJ+7o\u001c7wKJ\u0004\"AF\f\u000e\u0003\u0011I!\u0001\u0007\u0003\u0003\u000f1{wmZ5oO\"A!\u0004\u0001B\u0001B\u0003%A$\u0001\u0003d_:47\u0001\u0001\t\u0003-uI!A\b\u0003\u0003\u0013M\u0003\u0018M]6D_:4\u0007\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\u0002\u001b}\u0013Gn\\2l\u001b\u0006t\u0017mZ3s!\t\u0011S%D\u0001$\u0015\t!C!A\u0004ti>\u0014\u0018mZ3\n\u0005\u0019\u001a#\u0001\u0004\"m_\u000e\\W*\u00198bO\u0016\u0014\b\"\u0002\u0015\u0001\t\u0003I\u0013A\u0002\u001fj]&$h\bF\u0002+W1\u0002\"A\u0005\u0001\t\u000bi9\u0003\u0019\u0001\u000f\t\u000f\u0001:\u0003\u0013!a\u0001C!Aa\u0006\u0001EC\u0002\u0013%q&\u0001\u0007cY>\u001c7.T1oC\u001e,'/F\u0001\"\u0011!\t\u0004\u0001#A!B\u0013\t\u0013!\u00042m_\u000e\\W*\u00198bO\u0016\u0014\b\u0005C\u00044\u0001\t\u0007I\u0011\u0002\u001b\u0002\u001bQ\u0014\u0018M\\:q_J$8i\u001c8g+\u0005)\u0004C\u0001\u001c<\u001b\u00059$B\u0001\u001d:\u0003\u0011)H/\u001b7\u000b\u0005i\"\u0011a\u00028fi^|'o[\u0005\u0003y]\u0012Q\u0002\u0016:b]N\u0004xN\u001d;D_:4\u0007B\u0002 \u0001A\u0003%Q'\u0001\bue\u0006t7\u000f]8si\u000e{gN\u001a\u0011\t\u000b\u0001\u0003A\u0011A!\u0002\u0017\u001d,G\u000fR1uC\u001aKG.\u001a\u000b\u0004\u0005*{\u0005CA\"I\u001b\u0005!%BA#G\u0003\tIwNC\u0001H\u0003\u0011Q\u0017M^1\n\u0005%#%\u0001\u0002$jY\u0016DQaS A\u00021\u000b\u0011b\u001d5vM\u001adW-\u00133\u0011\u00051i\u0015B\u0001(\u000e\u0005\rIe\u000e\u001e\u0005\u0006!~\u0002\r\u0001T\u0001\u0006[\u0006\u0004\u0018\n\u001a\u0005\u0006%\u0002!IaU\u0001\rO\u0016$\u0018J\u001c3fq\u001aKG.\u001a\u000b\u0004\u0005R+\u0006\"B&R\u0001\u0004a\u0005\"\u0002)R\u0001\u0004a\u0005\"B,\u0001\t\u0003A\u0016a\u0004:f[>4X\rR1uC\nKX*\u00199\u0015\u0007ecV\f\u0005\u0002\r5&\u00111,\u0004\u0002\u0005+:LG\u000fC\u0003L-\u0002\u0007A\nC\u0003Q-\u0002\u0007A\nC\u0003`\u0001\u0011%\u0001-A\u000bdQ\u0016\u001c7.\u00138eKb\fe\u000e\u001a#bi\u00064\u0015\u000e\\3\u0015\t\u0005<\u0017n\u001b\t\u0004\u0019\t$\u0017BA2\u000e\u0005\u0015\t%O]1z!\taQ-\u0003\u0002g\u001b\t!Aj\u001c8h\u0011\u0015Ag\f1\u0001C\u0003\u0015Ig\u000eZ3y\u0011\u0015Qg\f1\u0001C\u0003\u0011!\u0017\r^1\t\u000b1t\u0006\u0019\u0001'\u0002\r\tdwnY6t\u0011\u0015q\u0007\u0001\"\u0001p\u0003]9(/\u001b;f\u0013:$W\r\u001f$jY\u0016\fe\u000eZ\"p[6LG\u000fF\u0003ZaF\u0014H\u000fC\u0003L[\u0002\u0007A\nC\u0003Q[\u0002\u0007A\nC\u0003t[\u0002\u0007\u0011-A\u0004mK:<G\u000f[:\t\u000bUl\u0007\u0019\u0001\"\u0002\u000f\u0011\fG/\u0019+na\")q\u000f\u0001C!q\u0006aq-\u001a;CY>\u001c7\u000eR1uCR\u0011\u0011p \t\u0003uvl\u0011a\u001f\u0006\u0003yf\naAY;gM\u0016\u0014\u0018B\u0001@|\u00055i\u0015M\\1hK\u0012\u0014UO\u001a4fe\"9\u0011\u0011\u0001<A\u0002\u0005\r\u0011a\u00022m_\u000e\\\u0017\n\u001a\t\u0004E\u0005\u0015\u0011bAA\u0004G\tq1\u000b[;gM2,'\t\\8dW&#\u0007bBA\u0006\u0001\u0011\u0005\u0013QB\u0001\u0005gR|\u0007\u000fF\u0001Z\u000f!\t\tB\u0001E\u0001\t\u0005M\u0011!G%oI\u0016D8\u000b[;gM2,'\t\\8dWJ+7o\u001c7wKJ\u00042AEA\u000b\r\u001d\t!\u0001#\u0001\u0005\u0003/\u00192!!\u0006\f\u0011\u001dA\u0013Q\u0003C\u0001\u00037!\"!a\u0005\t\u0015\u0005}\u0011Q\u0003b\u0001\n\u0003\t\t#\u0001\bO\u001f>\u0003vLU#E+\u000e+u,\u0013#\u0016\u00031C\u0001\"!\n\u0002\u0016\u0001\u0006I\u0001T\u0001\u0010\u001d>{\u0005k\u0018*F\tV\u001bUiX%EA!Q\u0011\u0011FA\u000b#\u0003%\t!a\u000b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tiCK\u0002\"\u0003_Y#!!\r\u0011\t\u0005M\u0012QH\u0007\u0003\u0003kQA!a\u000e\u0002:\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003wi\u0011AC1o]>$\u0018\r^5p]&!\u0011qHA\u001b\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class IndexShuffleBlockResolver
implements ShuffleBlockResolver,
Logging {
    private final BlockManager _blockManager;
    private BlockManager blockManager;
    private final TransportConf transportConf;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile boolean bitmap$0;

    public static BlockManager $lessinit$greater$default$2() {
        return IndexShuffleBlockResolver$.MODULE$.$lessinit$greater$default$2();
    }

    public static int NOOP_REDUCE_ID() {
        return IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BlockManager blockManager$lzycompute() {
        IndexShuffleBlockResolver indexShuffleBlockResolver = this;
        synchronized (indexShuffleBlockResolver) {
            if (!this.bitmap$0) {
                this.blockManager = (BlockManager)Option$.MODULE$.apply((Object)this._blockManager).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BlockManager apply() {
                        return SparkEnv$.MODULE$.get().blockManager();
                    }
                });
                this.bitmap$0 = true;
            }
        }
        this._blockManager = null;
        return this.blockManager;
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    private BlockManager blockManager() {
        return this.bitmap$0 ? this.blockManager : this.blockManager$lzycompute();
    }

    private TransportConf transportConf() {
        return this.transportConf;
    }

    public File getDataFile(int shuffleId, int mapId) {
        return this.blockManager().diskBlockManager().getFile(new ShuffleDataBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID()));
    }

    private File getIndexFile(int shuffleId, int mapId) {
        return this.blockManager().diskBlockManager().getFile(new ShuffleIndexBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID()));
    }

    public void removeDataByMap(int shuffleId, int mapId) {
        ObjectRef file = new ObjectRef((Object)this.getDataFile(shuffleId, mapId));
        if (((File)file.elem).exists() && !((File)file.elem).delete()) {
            this.logWarning((Function0<String>)new Serializable(this, file){
                public static final long serialVersionUID = 0L;
                private final ObjectRef file$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting data ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((File)this.file$1.elem).getPath()}));
                }
                {
                    this.file$1 = file$1;
                }
            });
        }
        file.elem = this.getIndexFile(shuffleId, mapId);
        if (((File)file.elem).exists() && !((File)file.elem).delete()) {
            this.logWarning((Function0<String>)new Serializable(this, file){
                public static final long serialVersionUID = 0L;
                private final ObjectRef file$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting index ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((File)this.file$1.elem).getPath()}));
                }
                {
                    this.file$1 = file$1;
                }
            });
        }
    }

    /*
     * Loose catch block
     */
    private long[] checkIndexAndDataFile(File index, File data, int blocks) {
        block13: {
            long[] lArray;
            block12: {
                block11: {
                    if (index.length() != (long)((blocks + 1) * 8)) {
                        return null;
                    }
                    long[] lengths = new long[blocks];
                    DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(index)));
                    try {
                        long offset = in.readLong();
                        if (offset != 0L) {
                            return null;
                        }
                        for (int i = 0; i < blocks; ++i) {
                            long off = in.readLong();
                            lengths[i] = off - offset;
                            offset = off;
                        }
                        if (data.length() != BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps(lengths).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))) break block11;
                        lArray = lengths;
                        break block12;
                    }
                    catch (IOException iOException) {
                        break block13;
                    }
                    finally {
                        in.close();
                    }
                }
                lArray = null;
            }
            return lArray;
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    public void writeIndexFileAndCommit(int shuffleId, int mapId, long[] lengths, File dataTmp) {
        File indexFile = this.getIndexFile(shuffleId, mapId);
        File indexTmp = Utils$.MODULE$.tempFileWith(indexFile);
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexTmp)));
        Utils$.MODULE$.tryWithSafeFinally(new Serializable(this, lengths, out){
            public static final long serialVersionUID = 0L;
            private final long[] lengths$1;
            public final DataOutputStream out$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LongRef offset = new LongRef(0L);
                this.out$1.writeLong(offset.elem);
                Predef$.MODULE$.longArrayOps(this.lengths$1).foreach((Function1)new Serializable(this, offset){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeIndexFileAndCommit$1 $outer;
                    private final LongRef offset$1;

                    public final void apply(long length) {
                        this.apply$mcVJ$sp(length);
                    }

                    public void apply$mcVJ$sp(long length) {
                        this.offset$1.elem += length;
                        this.$outer.out$1.writeLong(this.offset$1.elem);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.offset$1 = offset$1;
                    }
                });
            }
            {
                this.lengths$1 = lengths$1;
                this.out$1 = out$1;
            }
        }, (Function0<BoxedUnit>)new Serializable(this, out){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream out$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.out$1.close();
            }
            {
                this.out$1 = out$1;
            }
        });
        File dataFile = this.getDataFile(shuffleId, mapId);
        IndexShuffleBlockResolver indexShuffleBlockResolver = this;
        synchronized (indexShuffleBlockResolver) {
            block9: {
                block8: {
                    Boolean bl;
                    block7: {
                        long[] existingLengths = this.checkIndexAndDataFile(indexFile, dataFile, lengths.length);
                        if (existingLengths == null) break block7;
                        System.arraycopy(existingLengths, 0, lengths, 0, lengths.length);
                        Object object = dataTmp != null && dataTmp.exists() ? BoxesRunTime.boxToBoolean((boolean)dataTmp.delete()) : BoxedUnit.UNIT;
                        bl = BoxesRunTime.boxToBoolean((boolean)indexTmp.delete());
                        break block8;
                    }
                    Object object = indexFile.exists() ? BoxesRunTime.boxToBoolean((boolean)indexFile.delete()) : BoxedUnit.UNIT;
                    Object object2 = dataFile.exists() ? BoxesRunTime.boxToBoolean((boolean)dataFile.delete()) : BoxedUnit.UNIT;
                    if (!indexTmp.renameTo(indexFile)) break block9;
                    if (dataTmp != null && dataTmp.exists() && !dataTmp.renameTo(dataFile)) {
                        throw new IOException(new StringBuilder().append((Object)"fail to rename file ").append((Object)dataTmp).append((Object)" to ").append((Object)dataFile).toString());
                    }
                    bl = BoxedUnit.UNIT;
                }
                return;
            }
            throw new IOException(new StringBuilder().append((Object)"fail to rename file ").append((Object)indexTmp).append((Object)" to ").append((Object)indexFile).toString());
        }
    }

    @Override
    public ManagedBuffer getBlockData(ShuffleBlockId blockId) {
        File indexFile = this.getIndexFile(blockId.shuffleId(), blockId.mapId());
        DataInputStream in = new DataInputStream(new FileInputStream(indexFile));
        try {
            ByteStreams.skipFully((InputStream)in, (long)(blockId.reduceId() * 8));
            long offset = in.readLong();
            long nextOffset = in.readLong();
            return new FileSegmentManagedBuffer(this.transportConf(), this.getDataFile(blockId.shuffleId(), blockId.mapId()), offset, nextOffset - offset);
        }
        finally {
            in.close();
        }
    }

    @Override
    public void stop() {
    }

    public IndexShuffleBlockResolver(SparkConf conf, BlockManager _blockManager) {
        this._blockManager = _blockManager;
        Logging$class.$init$(this);
        this.transportConf = SparkTransportConf$.MODULE$.fromSparkConf(conf, "shuffle", SparkTransportConf$.MODULE$.fromSparkConf$default$3());
    }
}

