/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import org.apache.spark.scheduler.DAGScheduler;
import org.apache.spark.scheduler.JobFailed;
import org.apache.spark.scheduler.JobListener;
import org.apache.spark.scheduler.JobResult;
import org.apache.spark.scheduler.JobSucceeded$;
import scala.Function2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055a!B\u0001\u0003\u0001\u0011Q!!\u0003&pE^\u000b\u0017\u000e^3s\u0015\t\u0019A!A\u0005tG\",G-\u001e7fe*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014x-\u0006\u0002\f[M\u0019\u0001\u0001\u0004\n\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g!\t\u0019B#D\u0001\u0003\u0013\t)\"AA\u0006K_\nd\u0015n\u001d;f]\u0016\u0014\b\u0002C\f\u0001\u0005\u0003\u0005\u000b\u0011B\r\u0002\u0019\u0011\fwmU2iK\u0012,H.\u001a:\u0004\u0001A\u00111CG\u0005\u00037\t\u0011A\u0002R!H'\u000eDW\rZ;mKJD\u0001\"\b\u0001\u0003\u0006\u0004%\tAH\u0001\u0006U>\u0014\u0017\nZ\u000b\u0002?A\u0011Q\u0002I\u0005\u0003C9\u00111!\u00138u\u0011!\u0019\u0003A!A!\u0002\u0013y\u0012A\u00026pE&#\u0007\u0005\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003 \u0003)!x\u000e^1m)\u0006\u001c8n\u001d\u0005\tO\u0001\u0011\t\u0011)A\u0005Q\u0005i!/Z:vYRD\u0015M\u001c3mKJ\u0004R!D\u0015 WYJ!A\u000b\b\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004C\u0001\u0017.\u0019\u0001!QA\f\u0001C\u0002=\u0012\u0011\u0001V\t\u0003aM\u0002\"!D\u0019\n\u0005Ir!a\u0002(pi\"Lgn\u001a\t\u0003\u001bQJ!!\u000e\b\u0003\u0007\u0005s\u0017\u0010\u0005\u0002\u000eo%\u0011\u0001H\u0004\u0002\u0005+:LG\u000fC\u0003;\u0001\u0011\u00051(\u0001\u0004=S:LGO\u0010\u000b\u0006yurt\b\u0011\t\u0004'\u0001Y\u0003\"B\f:\u0001\u0004I\u0002\"B\u000f:\u0001\u0004y\u0002\"B\u0013:\u0001\u0004y\u0002\"B\u0014:\u0001\u0004A\u0003b\u0002\"\u0001\u0001\u0004%IAH\u0001\u000eM&t\u0017n\u001d5fIR\u000b7o[:\t\u000f\u0011\u0003\u0001\u0019!C\u0005\u000b\u0006\tb-\u001b8jg\",G\rV1tWN|F%Z9\u0015\u0005Y2\u0005bB$D\u0003\u0003\u0005\raH\u0001\u0004q\u0012\n\u0004BB%\u0001A\u0003&q$\u0001\bgS:L7\u000f[3e)\u0006\u001c8n\u001d\u0011\t\u000f-\u0003\u0001\u0019!C\u0005\u0019\u0006aqL[8c\r&t\u0017n\u001d5fIV\tQ\n\u0005\u0002\u000e\u001d&\u0011qJ\u0004\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0006\u00011A\u0005\nI\u000b\u0001c\u00186pE\u001aKg.[:iK\u0012|F%Z9\u0015\u0005Y\u001a\u0006bB$Q\u0003\u0003\u0005\r!\u0014\u0005\u0007+\u0002\u0001\u000b\u0015B'\u0002\u001b}SwN\u0019$j]&\u001c\b.\u001a3!Q\t!v\u000b\u0005\u0002\u000e1&\u0011\u0011L\u0004\u0002\tm>d\u0017\r^5mK\")1\f\u0001C\u0001\u0019\u0006Y!n\u001c2GS:L7\u000f[3e\u0011\u001di\u0006\u00011A\u0005\ny\u000b\u0011B[8c%\u0016\u001cX\u000f\u001c;\u0016\u0003}\u0003\"a\u00051\n\u0005\u0005\u0014!!\u0003&pEJ+7/\u001e7u\u0011\u001d\u0019\u0007\u00011A\u0005\n\u0011\fQB[8c%\u0016\u001cX\u000f\u001c;`I\u0015\fHC\u0001\u001cf\u0011\u001d9%-!AA\u0002}Caa\u001a\u0001!B\u0013y\u0016A\u00036pEJ+7/\u001e7uA!)\u0011\u000e\u0001C\u0001U\u000611-\u00198dK2$\u0012A\u000e\u0005\u0006Y\u0002!\t%\\\u0001\u000ei\u0006\u001c8nU;dG\u0016,G-\u001a3\u0015\u0007Yr\u0007\u000fC\u0003pW\u0002\u0007q$A\u0003j]\u0012,\u0007\u0010C\u0003rW\u0002\u00071'\u0001\u0004sKN,H\u000e\u001e\u0005\u0006g\u0002!\t\u0005^\u0001\nU>\u0014g)Y5mK\u0012$\"AN;\t\u000bY\u0014\b\u0019A<\u0002\u0013\u0015D8-\u001a9uS>t\u0007c\u0001=\u0002\u00029\u0011\u0011P \b\u0003uvl\u0011a\u001f\u0006\u0003yb\ta\u0001\u0010:p_Rt\u0014\"A\b\n\u0005}t\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003\u0007\t)AA\u0005Fq\u000e,\u0007\u000f^5p]*\u0011qP\u0004\u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0003-\tw/Y5u%\u0016\u001cX\u000f\u001c;\u0015\u0003}\u0003")
public class JobWaiter<T>
implements JobListener {
    private final DAGScheduler dagScheduler;
    private final int jobId;
    private final int totalTasks;
    private final Function2<Object, T, BoxedUnit> resultHandler;
    private int finishedTasks;
    private volatile boolean _jobFinished;
    private JobResult jobResult;

    public int jobId() {
        return this.jobId;
    }

    private int finishedTasks() {
        return this.finishedTasks;
    }

    private void finishedTasks_$eq(int x$1) {
        this.finishedTasks = x$1;
    }

    private boolean _jobFinished() {
        return this._jobFinished;
    }

    private void _jobFinished_$eq(boolean x$1) {
        this._jobFinished = x$1;
    }

    public boolean jobFinished() {
        return this._jobFinished();
    }

    private JobResult jobResult() {
        return this.jobResult;
    }

    private void jobResult_$eq(JobResult x$1) {
        this.jobResult = x$1;
    }

    public void cancel() {
        this.dagScheduler.cancelJob(this.jobId());
    }

    @Override
    public synchronized void taskSucceeded(int index, Object result) {
        if (this._jobFinished()) {
            throw new UnsupportedOperationException("taskSucceeded() called on a finished JobWaiter");
        }
        this.resultHandler.apply((Object)BoxesRunTime.boxToInteger((int)index), result);
        this.finishedTasks_$eq(this.finishedTasks() + 1);
        if (this.finishedTasks() == this.totalTasks) {
            this._jobFinished_$eq(true);
            this.jobResult_$eq(JobSucceeded$.MODULE$);
            this.notifyAll();
        }
    }

    @Override
    public synchronized void jobFailed(Exception exception2) {
        this._jobFinished_$eq(true);
        this.jobResult_$eq(new JobFailed(exception2));
        this.notifyAll();
    }

    public synchronized JobResult awaitResult() {
        while (!this._jobFinished()) {
            this.wait();
        }
        return this.jobResult();
    }

    public JobWaiter(DAGScheduler dagScheduler, int jobId, int totalTasks, Function2<Object, T, BoxedUnit> resultHandler) {
        this.dagScheduler = dagScheduler;
        this.jobId = jobId;
        this.totalTasks = totalTasks;
        this.resultHandler = resultHandler;
        this.finishedTasks = 0;
        boolean bl = this._jobFinished = totalTasks == 0;
        this.jobResult = this.jobFinished() ? JobSucceeded$.MODULE$ : null;
    }
}

