/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import org.apache.spark.SparkConf;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.StaticMemoryManager$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockStatus;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m4Q!\u0001\u0002\u0001\t)\u00111c\u0015;bi&\u001cW*Z7pefl\u0015M\\1hKJT!a\u0001\u0003\u0002\r5,Wn\u001c:z\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7C\u0001\u0001\f!\taQ\"D\u0001\u0003\u0013\tq!AA\u0007NK6|'/_'b]\u0006<WM\u001d\u0005\t!\u0001\u0011\t\u0011)A\u0005%\u0005!1m\u001c8g\u0007\u0001\u0001\"a\u0005\u000b\u000e\u0003\u0011I!!\u0006\u0003\u0003\u0013M\u0003\u0018M]6D_:4\u0007\u0002C\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u000215\f\u0007p\u00148IK\u0006\u0004X\t_3dkRLwN\\'f[>\u0014\u0018\u0010\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0003M_:<\u0007\u0002C\u0010\u0001\u0005\u000b\u0007I\u0011\t\u0011\u0002!5\f\u0007p\u0015;pe\u0006<W-T3n_JLX#\u0001\r\t\u0011\t\u0002!\u0011!Q\u0001\na\t\u0011#\\1y'R|'/Y4f\u001b\u0016lwN]=!\u0011!!\u0003A!A!\u0002\u0013)\u0013\u0001\u00038v[\u000e{'/Z:\u0011\u0005e1\u0013BA\u0014\u001b\u0005\rIe\u000e\u001e\u0005\u0006S\u0001!\tAK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b-bSFL\u0018\u0011\u00051\u0001\u0001\"\u0002\t)\u0001\u0004\u0011\u0002\"B\f)\u0001\u0004A\u0002\"B\u0010)\u0001\u0004A\u0002\"\u0002\u0013)\u0001\u0004)\u0003\"B\u0015\u0001\t\u0003\tDcA\u00163g!)\u0001\u0003\ra\u0001%!)A\u0005\ra\u0001K!9Q\u0007\u0001b\u0001\n\u0013\u0001\u0013aD7bqVs'o\u001c7m\u001b\u0016lwN]=\t\r]\u0002\u0001\u0015!\u0003\u0019\u0003Ai\u0017\r_+oe>dG.T3n_JL\b\u0005C\u0003:\u0001\u0011\u0005#(\u0001\u000bbGF,\u0018N]3Ti>\u0014\u0018mZ3NK6|'/\u001f\u000b\u0005wy2\u0005\n\u0005\u0002\u001ay%\u0011QH\u0007\u0002\b\u0005>|G.Z1o\u0011\u0015y\u0004\b1\u0001A\u0003\u001d\u0011Gn\\2l\u0013\u0012\u0004\"!\u0011#\u000e\u0003\tS!a\u0011\u0003\u0002\u000fM$xN]1hK&\u0011QI\u0011\u0002\b\u00052|7m[%e\u0011\u00159\u0005\b1\u0001\u0019\u0003!qW/\u001c\"zi\u0016\u001c\b\"B%9\u0001\u0004Q\u0015!D3wS\u000e$X\r\u001a\"m_\u000e\\7\u000fE\u0002L!Jk\u0011\u0001\u0014\u0006\u0003\u001b:\u000bq!\\;uC\ndWM\u0003\u0002P5\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Ec%A\u0002\"vM\u001a,'\u000f\u0005\u0003\u001a'\u0002+\u0016B\u0001+\u001b\u0005\u0019!V\u000f\u001d7feA\u0011\u0011IV\u0005\u0003/\n\u00131B\u00117pG.\u001cF/\u0019;vg\")\u0011\f\u0001C!5\u0006\u0019\u0012mY9vSJ,WK\u001c:pY2lU-\\8ssR!1h\u0017/^\u0011\u0015y\u0004\f1\u0001A\u0011\u00159\u0005\f1\u0001\u0019\u0011\u0015I\u0005\f1\u0001K\u0011\u0019y\u0006\u0001\"\u0011\u0003A\u00061\u0012mY9vSJ,W\t_3dkRLwN\\'f[>\u0014\u0018\u0010\u0006\u0003\u0019C\n$\u0007\"B$_\u0001\u0004A\u0002\"B2_\u0001\u0004A\u0012!\u0004;bg.\fE\u000f^3naRLE\rC\u0003f=\u0002\u0007a-\u0001\u0006nK6|'/_'pI\u0016\u0004\"\u0001D4\n\u0005!\u0014!AC'f[>\u0014\u00180T8eK\u001e1!N\u0001E\u0001\t-\f1c\u0015;bi&\u001cW*Z7pefl\u0015M\\1hKJ\u0004\"\u0001\u00047\u0007\r\u0005\u0011\u0001\u0012\u0001\u0003n'\tag\u000e\u0005\u0002\u001a_&\u0011\u0001O\u0007\u0002\u0007\u0003:L(+\u001a4\t\u000b%bG\u0011\u0001:\u0015\u0003-DQ\u0001\u001e7\u0005\nU\f1cZ3u\u001b\u0006D8\u000b^8sC\u001e,W*Z7pef$\"\u0001\u0007<\t\u000bA\u0019\b\u0019\u0001\n\t\u000badG\u0011B=\u0002+\u001d,G/T1y\u000bb,7-\u001e;j_:lU-\\8ssR\u0011\u0001D\u001f\u0005\u0006!]\u0004\rA\u0005")
public class StaticMemoryManager
extends MemoryManager {
    private final long maxStorageMemory;
    private final long maxUnrollMemory;

    @Override
    public long maxStorageMemory() {
        return this.maxStorageMemory;
    }

    private long maxUnrollMemory() {
        return this.maxUnrollMemory;
    }

    @Override
    public synchronized boolean acquireStorageMemory(BlockId blockId, long numBytes, Buffer<Tuple2<BlockId, BlockStatus>> evictedBlocks) {
        boolean bl;
        if (numBytes > this.maxStorageMemory()) {
            this.logInfo((Function0<String>)new Serializable(this, blockId, numBytes){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ StaticMemoryManager $outer;
                private final BlockId blockId$1;
                private final long numBytes$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Will not store ", " as the required space (", " bytes) exceeds our "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1, BoxesRunTime.boxToLong((long)this.numBytes$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"memory limit (", " bytes)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.maxStorageMemory())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.blockId$1 = blockId$1;
                    this.numBytes$1 = numBytes$1;
                }
            });
            bl = false;
        } else {
            bl = this.storageMemoryPool().acquireMemory(blockId, numBytes, evictedBlocks);
        }
        return bl;
    }

    @Override
    public synchronized boolean acquireUnrollMemory(BlockId blockId, long numBytes, Buffer<Tuple2<BlockId, BlockStatus>> evictedBlocks) {
        long currentUnrollMemory = this.storageMemoryPool().memoryStore().currentUnrollMemory();
        long freeMemory = this.storageMemoryPool().memoryFree();
        long maxNumBytesToFree = package$.MODULE$.max(0L, this.maxUnrollMemory() - currentUnrollMemory - freeMemory);
        long numBytesToFree = package$.MODULE$.max(0L, package$.MODULE$.min(maxNumBytesToFree, numBytes - freeMemory));
        return this.storageMemoryPool().acquireMemory(blockId, numBytes, numBytesToFree, evictedBlocks);
    }

    @Override
    public synchronized long acquireExecutionMemory(long numBytes, long taskAttemptId, MemoryMode memoryMode) {
        MemoryMode memoryMode2;
        block4: {
            long l;
            block3: {
                block2: {
                    memoryMode2 = memoryMode;
                    MemoryMode memoryMode3 = MemoryMode.ON_HEAP;
                    MemoryMode memoryMode4 = memoryMode2;
                    if (memoryMode3 != null ? !((Object)((Object)memoryMode3)).equals((Object)memoryMode4) : memoryMode4 != null) break block2;
                    l = this.onHeapExecutionMemoryPool().acquireMemory(numBytes, taskAttemptId, this.onHeapExecutionMemoryPool().acquireMemory$default$3(), this.onHeapExecutionMemoryPool().acquireMemory$default$4());
                    break block3;
                }
                MemoryMode memoryMode5 = MemoryMode.OFF_HEAP;
                MemoryMode memoryMode6 = memoryMode2;
                if (memoryMode5 != null ? !((Object)((Object)memoryMode5)).equals((Object)memoryMode6) : memoryMode6 != null) break block4;
                l = this.offHeapExecutionMemoryPool().acquireMemory(numBytes, taskAttemptId, this.offHeapExecutionMemoryPool().acquireMemory$default$3(), this.offHeapExecutionMemoryPool().acquireMemory$default$4());
            }
            return l;
        }
        throw new MatchError((Object)memoryMode2);
    }

    public StaticMemoryManager(SparkConf conf, long maxOnHeapExecutionMemory, long maxStorageMemory, int numCores) {
        this.maxStorageMemory = maxStorageMemory;
        super(conf, numCores, maxStorageMemory, maxOnHeapExecutionMemory);
        this.maxUnrollMemory = (long)((double)maxStorageMemory * conf.getDouble("spark.storage.unrollFraction", 0.2));
    }

    public StaticMemoryManager(SparkConf conf, int numCores) {
        this(conf, StaticMemoryManager$.MODULE$.org$apache$spark$memory$StaticMemoryManager$$getMaxExecutionMemory(conf), StaticMemoryManager$.MODULE$.org$apache$spark$memory$StaticMemoryManager$$getMaxStorageMemory(conf), numCores);
    }
}

