/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SparkConf;
import org.apache.spark.memory.ExecutionMemoryPool;
import org.apache.spark.memory.MemoryManager$;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.StorageMemoryPool;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.MemoryStore;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.unsafe.memory.MemoryAllocator;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.Buffer;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005-eAB\u0001\u0003\u0003\u0003!!BA\u0007NK6|'/_'b]\u0006<WM\u001d\u0006\u0003\u0007\u0011\ta!\\3n_JL(BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0014\u0007\u0001Y\u0011\u0003\u0005\u0002\r\u001f5\tQBC\u0001\u000f\u0003\u0015\u00198-\u00197b\u0013\t\u0001RB\u0001\u0004B]f\u0014VM\u001a\t\u0003%Mi\u0011\u0001B\u0005\u0003)\u0011\u0011q\u0001T8hO&tw\r\u0003\u0005\u0017\u0001\t\u0005\t\u0015!\u0003\u0019\u0003\u0011\u0019wN\u001c4\u0004\u0001A\u0011!#G\u0005\u00035\u0011\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u0011q\u0001!\u0011!Q\u0001\nu\t\u0001B\\;n\u0007>\u0014Xm\u001d\t\u0003\u0019yI!aH\u0007\u0003\u0007%sG\u000f\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u00035\u0019Ho\u001c:bO\u0016lU-\\8ssB\u0011AbI\u0005\u0003I5\u0011A\u0001T8oO\"Aa\u0005\u0001B\u0001B\u0003%!%A\u000bp]\"+\u0017\r]#yK\u000e,H/[8o\u001b\u0016lwN]=\t\u000b!\u0002A\u0011A\u0015\u0002\rqJg.\u001b;?)\u0015QC&\f\u00180!\tY\u0003!D\u0001\u0003\u0011\u00151r\u00051\u0001\u0019\u0011\u0015ar\u00051\u0001\u001e\u0011\u0015\ts\u00051\u0001#\u0011\u00151s\u00051\u0001#\u0011\u001d\t\u0004A1A\u0005\u0012I\n\u0011c\u001d;pe\u0006<W-T3n_JL\bk\\8m+\u0005\u0019\u0004CA\u00165\u0013\t)$AA\tTi>\u0014\u0018mZ3NK6|'/\u001f)p_2Daa\u000e\u0001!\u0002\u0013\u0019\u0014AE:u_J\fw-Z'f[>\u0014\u0018\u0010U8pY\u0002BCAN\u001dD\tB\u0011!(Q\u0007\u0002w)\u0011A(P\u0001\u000bG>t7-\u001e:sK:$(B\u0001 @\u0003)\tgN\\8uCRLwN\u001c\u0006\u0002\u0001\u0006)!.\u0019<bq&\u0011!i\u000f\u0002\n\u000fV\f'\u000fZ3e\u0005f\fQA^1mk\u0016\f\u0013!R\u0001\u0005i\"L7\u000fC\u0004H\u0001\t\u0007I\u0011\u0003%\u00023=t\u0007*Z1q\u000bb,7-\u001e;j_:lU-\\8ssB{w\u000e\\\u000b\u0002\u0013B\u00111FS\u0005\u0003\u0017\n\u00111#\u0012=fGV$\u0018n\u001c8NK6|'/\u001f)p_2Da!\u0014\u0001!\u0002\u0013I\u0015AG8o\u0011\u0016\f\u0007/\u0012=fGV$\u0018n\u001c8NK6|'/\u001f)p_2\u0004\u0003\u0006\u0002':\u0007\u0012Cq\u0001\u0015\u0001C\u0002\u0013E\u0001*\u0001\u000epM\u001aDU-\u00199Fq\u0016\u001cW\u000f^5p]6+Wn\u001c:z!>|G\u000e\u0003\u0004S\u0001\u0001\u0006I!S\u0001\u001c_\u001a4\u0007*Z1q\u000bb,7-\u001e;j_:lU-\\8ssB{w\u000e\u001c\u0011)\tEK4\t\u0012\u0005\u0006+\u00021\tAV\u0001\u0011[\u0006D8\u000b^8sC\u001e,W*Z7pef,\u0012A\t\u0005\u00061\u0002!)!W\u0001\u000fg\u0016$X*Z7pef\u001cFo\u001c:f)\tQV\f\u0005\u0002\r7&\u0011A,\u0004\u0002\u0005+:LG\u000fC\u0003_/\u0002\u0007q,A\u0003ti>\u0014X\r\u0005\u0002aG6\t\u0011M\u0003\u0002c\t\u000591\u000f^8sC\u001e,\u0017B\u00013b\u0005-iU-\\8ssN#xN]3\t\u000b\u0019\u0004a\u0011A4\u0002)\u0005\u001c\u0017/^5sKN#xN]1hK6+Wn\u001c:z)\u0011A7\u000e\u001d:\u0011\u00051I\u0017B\u00016\u000e\u0005\u001d\u0011un\u001c7fC:DQ\u0001\\3A\u00025\fqA\u00197pG.LE\r\u0005\u0002a]&\u0011q.\u0019\u0002\b\u00052|7m[%e\u0011\u0015\tX\r1\u0001#\u0003!qW/\u001c\"zi\u0016\u001c\b\"B:f\u0001\u0004!\u0018!D3wS\u000e$X\r\u001a\"m_\u000e\\7\u000fE\u0002vurl\u0011A\u001e\u0006\u0003ob\fq!\\;uC\ndWM\u0003\u0002z\u001b\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005m4(A\u0002\"vM\u001a,'\u000f\u0005\u0003\r{6|\u0018B\u0001@\u000e\u0005\u0019!V\u000f\u001d7feA\u0019\u0001-!\u0001\n\u0007\u0005\r\u0011MA\u0006CY>\u001c7n\u0015;biV\u001c\bbBA\u0004\u0001\u0019\u0005\u0011\u0011B\u0001\u0014C\u000e\fX/\u001b:f+:\u0014x\u000e\u001c7NK6|'/\u001f\u000b\bQ\u0006-\u0011QBA\b\u0011\u0019a\u0017Q\u0001a\u0001[\"1\u0011/!\u0002A\u0002\tBaa]A\u0003\u0001\u0004!\b\u0002CA\n\u0001\u0019\u0005!!!\u0006\u0002-\u0005\u001c\u0017/^5sK\u0016CXmY;uS>tW*Z7pef$rAIA\f\u00033\ti\u0002\u0003\u0004r\u0003#\u0001\rA\t\u0005\b\u00037\t\t\u00021\u0001#\u00035!\u0018m]6BiR,W\u000e\u001d;JI\"A\u0011qDA\t\u0001\u0004\t\t#\u0001\u0006nK6|'/_'pI\u0016\u00042aKA\u0012\u0013\r\t)C\u0001\u0002\u000b\u001b\u0016lwN]=N_\u0012,\u0007\u0002CA\u0015\u0001\u0011\u0005!!a\u000b\u0002-I,G.Z1tK\u0016CXmY;uS>tW*Z7pef$rAWA\u0017\u0003_\t\t\u0004\u0003\u0004r\u0003O\u0001\rA\t\u0005\b\u00037\t9\u00031\u0001#\u0011!\ty\"a\nA\u0002\u0005\u0005\u0002\u0002CA\u001b\u0001\u0011\u0005!!a\u000e\u0002AI,G.Z1tK\u0006cG.\u0012=fGV$\u0018n\u001c8NK6|'/\u001f$peR\u000b7o\u001b\u000b\u0004E\u0005e\u0002bBA\u000e\u0003g\u0001\rA\t\u0005\b\u0003{\u0001A\u0011AA \u0003Q\u0011X\r\\3bg\u0016\u001cFo\u001c:bO\u0016lU-\\8ssR\u0019!,!\u0011\t\rE\fY\u00041\u0001#\u0011\u001d\t)\u0005\u0001C\u0003\u0003\u000f\nqC]3mK\u0006\u001cX-\u00117m'R|'/Y4f\u001b\u0016lwN]=\u0015\u0003iCq!a\u0013\u0001\t\u000b\ti%A\nsK2,\u0017m]3V]J|G\u000e\\'f[>\u0014\u0018\u0010F\u0002[\u0003\u001fBa!]A%\u0001\u0004\u0011\u0003BBA*\u0001\u0011\u0015a+A\nfq\u0016\u001cW\u000f^5p]6+Wn\u001c:z+N,G\r\u0003\u0004\u0002X\u0001!)AV\u0001\u0012gR|'/Y4f\u001b\u0016lwN]=Vg\u0016$\u0007\u0002CA.\u0001\u0011\u0005!!!\u0018\u0002=\u001d,G/\u0012=fGV$\u0018n\u001c8NK6|'/_+tC\u001e,gi\u001c:UCN\\Gc\u0001\u0012\u0002`!9\u00111DA-\u0001\u0004\u0011\u0003\"CA2\u0001\t\u0007IQAA3\u0003I!XO\\4ti\u0016tW*Z7peflu\u000eZ3\u0016\u0005\u0005\u0005\u0002\u0002CA5\u0001\u0001\u0006i!!\t\u0002'Q,hnZ:uK:lU-\\8ss6{G-\u001a\u0011\t\u0011\u00055\u0004A1A\u0005\u0002Y\u000bQ\u0002]1hKNK'0\u001a\"zi\u0016\u001c\bbBA9\u0001\u0001\u0006IAI\u0001\u000fa\u0006<WmU5{K\nKH/Z:!\u0011)\t)\b\u0001b\u0001\n\u000b\u0011\u0011qO\u0001\u0018iVtwm\u001d;f]6+Wn\u001c:z\u00032dwnY1u_J,\"!!\u001f\u0011\t\u0005m\u00141Q\u0007\u0003\u0003{R1aAA@\u0015\r\t\t\tB\u0001\u0007k:\u001c\u0018MZ3\n\t\u0005\u0015\u0015Q\u0010\u0002\u0010\u001b\u0016lwN]=BY2|7-\u0019;pe\"A\u0011\u0011\u0012\u0001!\u0002\u001b\tI(\u0001\ruk:<7\u000f^3o\u001b\u0016lwN]=BY2|7-\u0019;pe\u0002\u0002")
public abstract class MemoryManager
implements Logging {
    @GuardedBy(value="this")
    private final StorageMemoryPool storageMemoryPool;
    @GuardedBy(value="this")
    private final ExecutionMemoryPool onHeapExecutionMemoryPool;
    @GuardedBy(value="this")
    private final ExecutionMemoryPool offHeapExecutionMemoryPool;
    private final MemoryMode tungstenMemoryMode;
    private final long pageSizeBytes;
    private final MemoryAllocator tungstenMemoryAllocator;
    private transient Logger org$apache$spark$Logging$$log_;

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public StorageMemoryPool storageMemoryPool() {
        return this.storageMemoryPool;
    }

    public ExecutionMemoryPool onHeapExecutionMemoryPool() {
        return this.onHeapExecutionMemoryPool;
    }

    public ExecutionMemoryPool offHeapExecutionMemoryPool() {
        return this.offHeapExecutionMemoryPool;
    }

    public abstract long maxStorageMemory();

    public final synchronized void setMemoryStore(MemoryStore store) {
        this.storageMemoryPool().setMemoryStore(store);
    }

    public abstract boolean acquireStorageMemory(BlockId var1, long var2, Buffer<Tuple2<BlockId, BlockStatus>> var4);

    public abstract boolean acquireUnrollMemory(BlockId var1, long var2, Buffer<Tuple2<BlockId, BlockStatus>> var4);

    public abstract long acquireExecutionMemory(long var1, long var3, MemoryMode var5);

    public synchronized void releaseExecutionMemory(long numBytes, long taskAttemptId, MemoryMode memoryMode) {
        MemoryMode memoryMode2;
        block4: {
            block3: {
                block2: {
                    memoryMode2 = memoryMode;
                    MemoryMode memoryMode3 = MemoryMode.ON_HEAP;
                    MemoryMode memoryMode4 = memoryMode2;
                    if (memoryMode3 != null ? !((Object)((Object)memoryMode3)).equals((Object)memoryMode4) : memoryMode4 != null) break block2;
                    this.onHeapExecutionMemoryPool().releaseMemory(numBytes, taskAttemptId);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                MemoryMode memoryMode5 = MemoryMode.OFF_HEAP;
                MemoryMode memoryMode6 = memoryMode2;
                if (memoryMode5 != null ? !((Object)((Object)memoryMode5)).equals((Object)memoryMode6) : memoryMode6 != null) break block4;
                this.offHeapExecutionMemoryPool().releaseMemory(numBytes, taskAttemptId);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)memoryMode2);
    }

    public synchronized long releaseAllExecutionMemoryForTask(long taskAttemptId) {
        return this.onHeapExecutionMemoryPool().releaseAllMemoryForTask(taskAttemptId) + this.offHeapExecutionMemoryPool().releaseAllMemoryForTask(taskAttemptId);
    }

    public synchronized void releaseStorageMemory(long numBytes) {
        this.storageMemoryPool().releaseMemory(numBytes);
    }

    public final synchronized void releaseAllStorageMemory() {
        this.storageMemoryPool().releaseAllMemory();
    }

    public final synchronized void releaseUnrollMemory(long numBytes) {
        this.releaseStorageMemory(numBytes);
    }

    public final synchronized long executionMemoryUsed() {
        return this.onHeapExecutionMemoryPool().memoryUsed() + this.offHeapExecutionMemoryPool().memoryUsed();
    }

    public final synchronized long storageMemoryUsed() {
        return this.storageMemoryPool().memoryUsed();
    }

    public synchronized long getExecutionMemoryUsageForTask(long taskAttemptId) {
        return this.onHeapExecutionMemoryPool().getMemoryUsageForTask(taskAttemptId) + this.offHeapExecutionMemoryPool().getMemoryUsageForTask(taskAttemptId);
    }

    public final MemoryMode tungstenMemoryMode() {
        return this.tungstenMemoryMode;
    }

    public long pageSizeBytes() {
        return this.pageSizeBytes;
    }

    public final MemoryAllocator tungstenMemoryAllocator() {
        return this.tungstenMemoryAllocator;
    }

    public MemoryManager(SparkConf conf, int numCores, long storageMemory, long onHeapExecutionMemory) {
        MemoryMode memoryMode;
        block7: {
            MemoryMode memoryMode2;
            block10: {
                MemoryAllocator memoryAllocator;
                block9: {
                    block8: {
                        long l;
                        int safetyFactor;
                        int cores;
                        long maxPageSize;
                        long minPageSize;
                        block6: {
                            block5: {
                                MemoryMode memoryMode3;
                                Logging$class.$init$(this);
                                this.storageMemoryPool = new StorageMemoryPool(this);
                                this.onHeapExecutionMemoryPool = new ExecutionMemoryPool(this, "on-heap execution");
                                this.offHeapExecutionMemoryPool = new ExecutionMemoryPool(this, "off-heap execution");
                                this.storageMemoryPool().incrementPoolSize(storageMemory);
                                this.onHeapExecutionMemoryPool().incrementPoolSize(onHeapExecutionMemory);
                                this.offHeapExecutionMemoryPool().incrementPoolSize(conf.getSizeAsBytes("spark.memory.offHeap.size", 0L));
                                if (conf.getBoolean("spark.memory.offHeap.enabled", false)) {
                                    Predef$.MODULE$.require(conf.getSizeAsBytes("spark.memory.offHeap.size", 0L) > 0L, (Function0)new $anonfun$1(this));
                                    memoryMode3 = MemoryMode.OFF_HEAP;
                                } else {
                                    memoryMode3 = MemoryMode.ON_HEAP;
                                }
                                this.tungstenMemoryMode = memoryMode3;
                                minPageSize = 0x100000L;
                                maxPageSize = 64L * minPageSize;
                                cores = numCores > 0 ? numCores : Runtime.getRuntime().availableProcessors();
                                safetyFactor = 16;
                                memoryMode = this.tungstenMemoryMode();
                                MemoryMode memoryMode4 = MemoryMode.ON_HEAP;
                                MemoryMode memoryMode5 = memoryMode;
                                if (memoryMode4 != null ? !((Object)((Object)memoryMode4)).equals((Object)memoryMode5) : memoryMode5 != null) break block5;
                                l = this.onHeapExecutionMemoryPool().poolSize();
                                break block6;
                            }
                            MemoryMode memoryMode6 = MemoryMode.OFF_HEAP;
                            MemoryMode memoryMode7 = memoryMode;
                            if (memoryMode6 != null ? !((Object)((Object)memoryMode6)).equals((Object)memoryMode7) : memoryMode7 != null) break block7;
                            l = this.offHeapExecutionMemoryPool().poolSize();
                        }
                        long maxTungstenMemory = l;
                        long size = ByteArrayMethods.nextPowerOf2((long)(maxTungstenMemory / (long)cores / (long)safetyFactor));
                        long l2 = package$.MODULE$.min(maxPageSize, package$.MODULE$.max(minPageSize, size));
                        this.pageSizeBytes = conf.getSizeAsBytes("spark.buffer.pageSize", l2);
                        memoryMode2 = this.tungstenMemoryMode();
                        MemoryMode memoryMode8 = MemoryMode.ON_HEAP;
                        MemoryMode memoryMode9 = memoryMode2;
                        if (memoryMode8 != null ? !((Object)((Object)memoryMode8)).equals((Object)memoryMode9) : memoryMode9 != null) break block8;
                        memoryAllocator = MemoryAllocator.HEAP;
                        break block9;
                    }
                    MemoryMode memoryMode10 = MemoryMode.OFF_HEAP;
                    MemoryMode memoryMode11 = memoryMode2;
                    if (memoryMode10 != null ? !((Object)((Object)memoryMode10)).equals((Object)memoryMode11) : memoryMode11 != null) break block10;
                    memoryAllocator = MemoryAllocator.UNSAFE;
                }
                this.tungstenMemoryAllocator = memoryAllocator;
                return;
            }
            throw new MatchError((Object)memoryMode2);
        }
        throw new MatchError((Object)memoryMode);
    }
}

