/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.io;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.spark.SparkConf;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.SnappyOutputStreamWrapper;
import org.xerial.snappy.Snappy;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;
import scala.reflect.ScalaSignature;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001m2A!\u0001\u0002\u0001\u0017\t12K\\1qaf\u001cu.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7M\u0003\u0002\u0004\t\u0005\u0011\u0011n\u001c\u0006\u0003\u000b\u0019\tQa\u001d9be.T!a\u0002\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0011aA8sO\u000e\u00011c\u0001\u0001\r%A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u0003!\r{W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0007\u0002C\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\t\r|gN\u001a\t\u00033ii\u0011\u0001B\u0005\u00037\u0011\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\ty\u0002\u0005\u0005\u0002\u0014\u0001!)q\u0003\ba\u00011!)!\u0005\u0001C!G\u000512m\\7qe\u0016\u001c8/\u001a3PkR\u0004X\u000f^*ue\u0016\fW\u000e\u0006\u0002%WA\u0011Q%K\u0007\u0002M)\u00111a\n\u0006\u0002Q\u0005!!.\u0019<b\u0013\tQcE\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW\u000eC\u0003-C\u0001\u0007A%A\u0001t\u0011\u0015q\u0003\u0001\"\u00110\u0003U\u0019w.\u001c9sKN\u001cX\rZ%oaV$8\u000b\u001e:fC6$\"\u0001M\u001a\u0011\u0005\u0015\n\u0014B\u0001\u001a'\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000b1j\u0003\u0019\u0001\u0019)\u0005\u0001)\u0004C\u0001\u001c:\u001b\u00059$B\u0001\u001d\u0005\u0003)\tgN\\8uCRLwN\\\u0005\u0003u]\u0012A\u0002R3wK2|\u0007/\u001a:Ba&\u0004")
public class SnappyCompressionCodec
implements CompressionCodec {
    private final SparkConf conf;

    @Override
    public OutputStream compressedOutputStream(OutputStream s) {
        int blockSize = (int)this.conf.getSizeAsBytes("spark.io.compression.snappy.blockSize", "32k");
        return new SnappyOutputStreamWrapper(new SnappyOutputStream(s, blockSize));
    }

    @Override
    public InputStream compressedInputStream(InputStream s) {
        return new SnappyInputStream(s);
    }

    public SnappyCompressionCodec(SparkConf conf) {
        this.conf = conf;
        try {
            Snappy.getNativeLibraryVersion();
        }
        catch (Error error2) {
            throw new IllegalArgumentException(error2);
        }
    }
}

