/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.worker;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import org.apache.spark.SparkConf;
import org.apache.spark.util.IntParam$;
import org.apache.spark.util.MemoryParam$;
import org.apache.spark.util.Utils$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%b!B\u0001\u0003\u0001\ta!aD,pe.,'/\u0011:hk6,g\u000e^:\u000b\u0005\r!\u0011AB<pe.,'O\u0003\u0002\u0006\r\u00051A-\u001a9m_fT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\n\u0003\u00015\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007\u0002\u0003\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\t\u0005\u0014xm]\u0002\u0001!\rqq#G\u0005\u00031=\u0011Q!\u0011:sCf\u0004\"AG\u000f\u000f\u00059Y\u0012B\u0001\u000f\u0010\u0003\u0019\u0001&/\u001a3fM&\u0011ad\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005qy\u0001\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\u0002\t\r|gN\u001a\t\u0003G\u0011j\u0011AB\u0005\u0003K\u0019\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u000b\u001d\u0002A\u0011\u0001\u0015\u0002\rqJg.\u001b;?)\rI3\u0006\f\t\u0003U\u0001i\u0011A\u0001\u0005\u0006)\u0019\u0002\rA\u0006\u0005\u0006C\u0019\u0002\rA\t\u0005\b]\u0001\u0001\r\u0011\"\u00010\u0003\u0011Awn\u001d;\u0016\u0003eAq!\r\u0001A\u0002\u0013\u0005!'\u0001\u0005i_N$x\fJ3r)\t\u0019d\u0007\u0005\u0002\u000fi%\u0011Qg\u0004\u0002\u0005+:LG\u000fC\u00048a\u0005\u0005\t\u0019A\r\u0002\u0007a$\u0013\u0007\u0003\u0004:\u0001\u0001\u0006K!G\u0001\u0006Q>\u001cH\u000f\t\u0005\bw\u0001\u0001\r\u0011\"\u0001=\u0003\u0011\u0001xN\u001d;\u0016\u0003u\u0002\"A\u0004 \n\u0005}z!aA%oi\"9\u0011\t\u0001a\u0001\n\u0003\u0011\u0015\u0001\u00039peR|F%Z9\u0015\u0005M\u001a\u0005bB\u001cA\u0003\u0003\u0005\r!\u0010\u0005\u0007\u000b\u0002\u0001\u000b\u0015B\u001f\u0002\u000bA|'\u000f\u001e\u0011\t\u000f\u001d\u0003\u0001\u0019!C\u0001y\u0005Iq/\u001a2VSB{'\u000f\u001e\u0005\b\u0013\u0002\u0001\r\u0011\"\u0001K\u000359XMY+j!>\u0014Ho\u0018\u0013fcR\u00111g\u0013\u0005\bo!\u000b\t\u00111\u0001>\u0011\u0019i\u0005\u0001)Q\u0005{\u0005Qq/\u001a2VSB{'\u000f\u001e\u0011\t\u000f=\u0003\u0001\u0019!C\u0001y\u0005)1m\u001c:fg\"9\u0011\u000b\u0001a\u0001\n\u0003\u0011\u0016!C2pe\u0016\u001cx\fJ3r)\t\u00194\u000bC\u00048!\u0006\u0005\t\u0019A\u001f\t\rU\u0003\u0001\u0015)\u0003>\u0003\u0019\u0019wN]3tA!9q\u000b\u0001a\u0001\n\u0003a\u0014AB7f[>\u0014\u0018\u0010C\u0004Z\u0001\u0001\u0007I\u0011\u0001.\u0002\u00155,Wn\u001c:z?\u0012*\u0017\u000f\u0006\u000247\"9q\u0007WA\u0001\u0002\u0004i\u0004BB/\u0001A\u0003&Q(A\u0004nK6|'/\u001f\u0011\t\u000f}\u0003\u0001\u0019!C\u0001A\u00069Q.Y:uKJ\u001cX#\u0001\f\t\u000f\t\u0004\u0001\u0019!C\u0001G\u0006YQ.Y:uKJ\u001cx\fJ3r)\t\u0019D\rC\u00048C\u0006\u0005\t\u0019\u0001\f\t\r\u0019\u0004\u0001\u0015)\u0003\u0017\u0003!i\u0017m\u001d;feN\u0004\u0003b\u00025\u0001\u0001\u0004%\taL\u0001\bo>\u00148\u000eR5s\u0011\u001dQ\u0007\u00011A\u0005\u0002-\f1b^8sW\u0012K'o\u0018\u0013fcR\u00111\u0007\u001c\u0005\bo%\f\t\u00111\u0001\u001a\u0011\u0019q\u0007\u0001)Q\u00053\u0005Aqo\u001c:l\t&\u0014\b\u0005C\u0004q\u0001\u0001\u0007I\u0011A\u0018\u0002\u001dA\u0014x\u000e]3si&,7OR5mK\"9!\u000f\u0001a\u0001\n\u0003\u0019\u0018A\u00059s_B,'\u000f^5fg\u001aKG.Z0%KF$\"a\r;\t\u000f]\n\u0018\u0011!a\u00013!1a\u000f\u0001Q!\ne\tq\u0002\u001d:pa\u0016\u0014H/[3t\r&dW\r\t\u0005\u0006q\u0002!I!_\u0001\u0006a\u0006\u00148/\u001a\u000b\u0003giDQ\u0001F<A\u0002m\u0004B\u0001`A\u000539\u0019Q0!\u0002\u000f\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\t!F\u0001\u0007yI|w\u000e\u001e \n\u0003AI1!a\u0002\u0010\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0003\u0002\u000e\t!A*[:u\u0015\r\t9a\u0004\u0005\b\u0003#\u0001A\u0011AA\n\u0003E\u0001(/\u001b8u+N\fw-Z!oI\u0016C\u0018\u000e\u001e\u000b\u0004g\u0005U\u0001bBA\f\u0003\u001f\u0001\r!P\u0001\tKbLGoQ8eK\"9\u00111\u0004\u0001\u0005\u0002\u0005u\u0011!E5oM\u0016\u0014H)\u001a4bk2$8i\u001c:fgR\tQ\bC\u0004\u0002\"\u0001!\t!!\b\u0002%%tg-\u001a:EK\u001a\fW\u000f\u001c;NK6|'/\u001f\u0005\b\u0003K\u0001A\u0011AA\u0014\u0003E\u0019\u0007.Z2l/>\u00148.\u001a:NK6|'/\u001f\u000b\u0002g\u0001")
public class WorkerArguments {
    private String host = Utils$.MODULE$.localHostName();
    private int port = 0;
    private int webUiPort = 8081;
    private int cores = this.inferDefaultCores();
    private int memory = this.inferDefaultMemory();
    private String[] masters = null;
    private String workDir = null;
    private String propertiesFile = null;

    public String host() {
        return this.host;
    }

    public void host_$eq(String x$1) {
        this.host = x$1;
    }

    public int port() {
        return this.port;
    }

    public void port_$eq(int x$1) {
        this.port = x$1;
    }

    public int webUiPort() {
        return this.webUiPort;
    }

    public void webUiPort_$eq(int x$1) {
        this.webUiPort = x$1;
    }

    public int cores() {
        return this.cores;
    }

    public void cores_$eq(int x$1) {
        this.cores = x$1;
    }

    public int memory() {
        return this.memory;
    }

    public void memory_$eq(int x$1) {
        this.memory = x$1;
    }

    public String[] masters() {
        return this.masters;
    }

    public void masters_$eq(String[] x$1) {
        this.masters = x$1;
    }

    public String workDir() {
        return this.workDir;
    }

    public void workDir_$eq(String x$1) {
        this.workDir = x$1;
    }

    public String propertiesFile() {
        return this.propertiesFile;
    }

    public void propertiesFile_$eq(String x$1) {
        this.propertiesFile = x$1;
    }

    private void parse(List<String> args) {
        block40: {
            List list;
            while (true) {
                boolean bl = false;
                .colon.colon colon2 = null;
                list = args;
                if (list instanceof .colon.colon) {
                    boolean bl2;
                    bl = true;
                    colon2 = (.colon.colon)list;
                    String string = (String)colon2.hd$1();
                    List list2 = colon2.tl$1();
                    String string2 = string;
                    if (!("--ip" != null ? !"--ip".equals(string2) : string2 != null)) {
                        bl2 = true;
                    } else {
                        String string3 = string;
                        bl2 = !("-i" != null ? !"-i".equals(string3) : string3 != null);
                    }
                    if (bl2 && list2 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list2;
                        String value = (String)colon3.hd$1();
                        List tail = colon3.tl$1();
                        Utils$.MODULE$.checkHost(value, new StringBuilder().append((Object)"ip no longer supported, please use hostname ").append((Object)value).toString());
                        this.host_$eq(value);
                        args = tail;
                        continue;
                    }
                }
                if (bl) {
                    boolean bl3;
                    String string = (String)colon2.hd$1();
                    List list3 = colon2.tl$1();
                    String string4 = string;
                    if (!("--host" != null ? !"--host".equals(string4) : string4 != null)) {
                        bl3 = true;
                    } else {
                        String string5 = string;
                        bl3 = !("-h" != null ? !"-h".equals(string5) : string5 != null);
                    }
                    if (bl3 && list3 instanceof .colon.colon) {
                        .colon.colon colon4 = (.colon.colon)list3;
                        String value = (String)colon4.hd$1();
                        List tail = colon4.tl$1();
                        Utils$.MODULE$.checkHost(value, new StringBuilder().append((Object)"Please use hostname ").append((Object)value).toString());
                        this.host_$eq(value);
                        args = tail;
                        continue;
                    }
                }
                if (bl) {
                    boolean bl4;
                    String string = (String)colon2.hd$1();
                    List list4 = colon2.tl$1();
                    String string6 = string;
                    if (!("--port" != null ? !"--port".equals(string6) : string6 != null)) {
                        bl4 = true;
                    } else {
                        String string7 = string;
                        bl4 = !("-p" != null ? !"-p".equals(string7) : string7 != null);
                    }
                    if (bl4 && list4 instanceof .colon.colon) {
                        .colon.colon colon5 = (.colon.colon)list4;
                        String string8 = (String)colon5.hd$1();
                        List tail = colon5.tl$1();
                        Option<Object> option = IntParam$.MODULE$.unapply(string8);
                        if (!option.isEmpty()) {
                            int value = BoxesRunTime.unboxToInt((Object)option.get());
                            this.port_$eq(value);
                            args = tail;
                            continue;
                        }
                    }
                }
                if (bl) {
                    boolean bl5;
                    String string = (String)colon2.hd$1();
                    List list5 = colon2.tl$1();
                    String string9 = string;
                    if (!("--cores" != null ? !"--cores".equals(string9) : string9 != null)) {
                        bl5 = true;
                    } else {
                        String string10 = string;
                        bl5 = !("-c" != null ? !"-c".equals(string10) : string10 != null);
                    }
                    if (bl5 && list5 instanceof .colon.colon) {
                        .colon.colon colon6 = (.colon.colon)list5;
                        String string11 = (String)colon6.hd$1();
                        List tail = colon6.tl$1();
                        Option<Object> option = IntParam$.MODULE$.unapply(string11);
                        if (!option.isEmpty()) {
                            int value = BoxesRunTime.unboxToInt((Object)option.get());
                            this.cores_$eq(value);
                            args = tail;
                            continue;
                        }
                    }
                }
                if (bl) {
                    boolean bl6;
                    String string = (String)colon2.hd$1();
                    List list6 = colon2.tl$1();
                    String string12 = string;
                    if (!("--memory" != null ? !"--memory".equals(string12) : string12 != null)) {
                        bl6 = true;
                    } else {
                        String string13 = string;
                        bl6 = !("-m" != null ? !"-m".equals(string13) : string13 != null);
                    }
                    if (bl6 && list6 instanceof .colon.colon) {
                        .colon.colon colon7 = (.colon.colon)list6;
                        String string14 = (String)colon7.hd$1();
                        List tail = colon7.tl$1();
                        Option<Object> option = MemoryParam$.MODULE$.unapply(string14);
                        if (!option.isEmpty()) {
                            int value = BoxesRunTime.unboxToInt((Object)option.get());
                            this.memory_$eq(value);
                            args = tail;
                            continue;
                        }
                    }
                }
                if (bl) {
                    boolean bl7;
                    String string = (String)colon2.hd$1();
                    List list7 = colon2.tl$1();
                    String string15 = string;
                    if (!("--work-dir" != null ? !"--work-dir".equals(string15) : string15 != null)) {
                        bl7 = true;
                    } else {
                        String string16 = string;
                        bl7 = !("-d" != null ? !"-d".equals(string16) : string16 != null);
                    }
                    if (bl7 && list7 instanceof .colon.colon) {
                        .colon.colon colon8 = (.colon.colon)list7;
                        String value = (String)colon8.hd$1();
                        List tail = colon8.tl$1();
                        this.workDir_$eq(value);
                        args = tail;
                        continue;
                    }
                }
                if (bl) {
                    String string = (String)colon2.hd$1();
                    List list8 = colon2.tl$1();
                    String string17 = string;
                    if (!("--webui-port" != null ? !"--webui-port".equals(string17) : string17 != null) && list8 instanceof .colon.colon) {
                        .colon.colon colon9 = (.colon.colon)list8;
                        String string18 = (String)colon9.hd$1();
                        List tail = colon9.tl$1();
                        Option<Object> option = IntParam$.MODULE$.unapply(string18);
                        if (!option.isEmpty()) {
                            int value = BoxesRunTime.unboxToInt((Object)option.get());
                            this.webUiPort_$eq(value);
                            args = tail;
                            continue;
                        }
                    }
                }
                if (bl) {
                    String string = (String)colon2.hd$1();
                    List list9 = colon2.tl$1();
                    String string19 = string;
                    if (!("--properties-file" != null ? !"--properties-file".equals(string19) : string19 != null) && list9 instanceof .colon.colon) {
                        .colon.colon colon10 = (.colon.colon)list9;
                        String value = (String)colon10.hd$1();
                        List tail = colon10.tl$1();
                        this.propertiesFile_$eq(value);
                        args = tail;
                        continue;
                    }
                }
                if (bl) {
                    String string;
                    String string20 = string = (String)colon2.hd$1();
                    if (!("--help" != null ? !"--help".equals(string20) : string20 != null)) {
                        this.printUsageAndExit(0);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block40;
                    }
                }
                if (!bl) break;
                String value = (String)colon2.hd$1();
                List tail = colon2.tl$1();
                if (this.masters() != null) {
                    this.printUsageAndExit(1);
                }
                this.masters_$eq(Utils$.MODULE$.parseStandaloneMasterUrls(value));
                args = tail;
            }
            Nil$ nil$ = Nil$.MODULE$;
            List list10 = list;
            if (!(nil$ != null ? !nil$.equals(list10) : list10 != null)) {
                BoxedUnit boxedUnit;
                if (this.masters() == null) {
                    this.printUsageAndExit(1);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                this.printUsageAndExit(1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void printUsageAndExit(int exitCode) {
        System.err.println("Usage: Worker [options] <master>\n\nMaster must be a URL of the form spark://hostname:port\n\nOptions:\n  -c CORES, --cores CORES  Number of cores to use\n  -m MEM, --memory MEM     Amount of memory to use (e.g. 1000M, 2G)\n  -d DIR, --work-dir DIR   Directory to run apps in (default: SPARK_HOME/work)\n  -i HOST, --ip IP         Hostname to listen on (deprecated, please use --host or -h)\n  -h HOST, --host HOST     Hostname to listen on\n  -p PORT, --port PORT     Port to listen on (default: random)\n  --webui-port PORT        Port for web UI (default: 8081)\n  --properties-file FILE   Path to a custom Spark properties file.\n                           Default is conf/spark-defaults.conf.");
        System.exit(exitCode);
    }

    public int inferDefaultCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    public int inferDefaultMemory() {
        boolean ibmVendor = System.getProperty("java.vendor").contains("IBM");
        int totalMb = 0;
        try {
            OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();
            if (ibmVendor) {
                Class<?> beanClass = Class.forName("com.ibm.lang.management.OperatingSystemMXBean");
                Method method = beanClass.getDeclaredMethod("getTotalPhysicalMemory", new Class[0]);
                totalMb = (int)(BoxesRunTime.unboxToLong((Object)method.invoke((Object)bean, new Object[0])) / 1024L / 1024L);
            } else {
                Class<?> beanClass = Class.forName("com.sun.management.OperatingSystemMXBean");
                Method method = beanClass.getDeclaredMethod("getTotalPhysicalMemorySize", new Class[0]);
                totalMb = (int)(BoxesRunTime.unboxToLong((Object)method.invoke((Object)bean, new Object[0])) / 1024L / 1024L);
            }
        }
        catch (Exception exception2) {
            totalMb = 2048;
            System.out.println(new StringBuilder().append((Object)"Failed to get total physical memory. Using ").append((Object)BoxesRunTime.boxToInteger((int)totalMb)).append((Object)" MB").toString());
        }
        return package$.MODULE$.max(totalMb - 1024, Utils$.MODULE$.DEFAULT_DRIVER_MEM_MB());
    }

    public void checkWorkerMemory() {
        if (this.memory() <= 0) {
            String message = "Memory can't be 0, missing a M or G on the end of the memory specification?";
            throw new IllegalStateException(message);
        }
    }

    public WorkerArguments(String[] args, SparkConf conf) {
        if (System.getenv("SPARK_WORKER_PORT") != null) {
            this.port_$eq(new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_WORKER_PORT"))).toInt());
        }
        if (System.getenv("SPARK_WORKER_CORES") != null) {
            this.cores_$eq(new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_WORKER_CORES"))).toInt());
        }
        if (conf.getenv("SPARK_WORKER_MEMORY") != null) {
            this.memory_$eq(Utils$.MODULE$.memoryStringToMb(conf.getenv("SPARK_WORKER_MEMORY")));
        }
        if (System.getenv("SPARK_WORKER_WEBUI_PORT") != null) {
            this.webUiPort_$eq(new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_WORKER_WEBUI_PORT"))).toInt());
        }
        if (System.getenv("SPARK_WORKER_DIR") != null) {
            this.workDir_$eq(System.getenv("SPARK_WORKER_DIR"));
        }
        this.parse((List<String>)Predef$.MODULE$.refArrayOps((Object[])args).toList());
        this.propertiesFile_$eq(Utils$.MODULE$.loadDefaultSparkProperties(conf, this.propertiesFile()));
        if (conf.contains("spark.worker.ui.port")) {
            this.webUiPort_$eq(new StringOps(Predef$.MODULE$.augmentString(conf.get("spark.worker.ui.port"))).toInt());
        }
        this.checkWorkerMemory();
    }
}

