/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.File;
import org.apache.spark.HttpServer$;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SecurityManager;
import org.apache.spark.ServerStateException;
import org.apache.spark.SparkConf;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.spark-project.jetty.security.ConstraintMapping;
import org.spark-project.jetty.security.ConstraintSecurityHandler;
import org.spark-project.jetty.security.HashLoginService;
import org.spark-project.jetty.security.authentication.DigestAuthenticator;
import org.spark-project.jetty.server.Handler;
import org.spark-project.jetty.server.Server;
import org.spark-project.jetty.server.bio.SocketConnector;
import org.spark-project.jetty.server.handler.DefaultHandler;
import org.spark-project.jetty.server.handler.HandlerList;
import org.spark-project.jetty.server.handler.ResourceHandler;
import org.spark-project.jetty.server.ssl.SslSocketConnector;
import org.spark-project.jetty.util.security.Constraint;
import org.spark-project.jetty.util.security.Password;
import org.spark-project.jetty.util.ssl.SslContextFactory;
import org.spark-project.jetty.util.thread.QueuedThreadPool;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb!B\u0001\u0003\u0001\tA!A\u0003%uiB\u001cVM\u001d<fe*\u00111\u0001B\u0001\u0006gB\f'o\u001b\u0006\u0003\u000b\u0019\ta!\u00199bG\",'\"A\u0004\u0002\u0007=\u0014xmE\u0002\u0001\u0013=\u0001\"AC\u0007\u000e\u0003-Q\u0011\u0001D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001d-\u0011a!\u00118z%\u00164\u0007C\u0001\t\u0012\u001b\u0005\u0011\u0011B\u0001\n\u0003\u0005\u001daunZ4j]\u001eD\u0001\u0002\u0006\u0001\u0003\u0002\u0003\u0006IAF\u0001\u0005G>tgm\u0001\u0001\u0011\u0005A9\u0012B\u0001\r\u0003\u0005%\u0019\u0006/\u0019:l\u0007>tg\r\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u001c\u00031\u0011Xm]8ve\u000e,')Y:f!\ta\u0012%D\u0001\u001e\u0015\tqr$\u0001\u0002j_*\t\u0001%\u0001\u0003kCZ\f\u0017B\u0001\u0012\u001e\u0005\u00111\u0015\u000e\\3\t\u0011\u0011\u0002!\u0011!Q\u0001\n\u0015\nqb]3dkJLG/_'b]\u0006<WM\u001d\t\u0003!\u0019J!a\n\u0002\u0003\u001fM+7-\u001e:jifl\u0015M\\1hKJD\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IAK\u0001\u000ee\u0016\fX/Z:uK\u0012\u0004vN\u001d;\u0011\u0005)Y\u0013B\u0001\u0017\f\u0005\rIe\u000e\u001e\u0005\t]\u0001\u0011\t\u0011)A\u0005_\u0005Q1/\u001a:wKJt\u0015-\\3\u0011\u0005A\u001adB\u0001\u00062\u0013\t\u00114\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003iU\u0012aa\u0015;sS:<'B\u0001\u001a\f\u0011\u00159\u0004\u0001\"\u00019\u0003\u0019a\u0014N\\5u}Q1\u0011HO\u001e={y\u0002\"\u0001\u0005\u0001\t\u000bQ1\u0004\u0019\u0001\f\t\u000bi1\u0004\u0019A\u000e\t\u000b\u00112\u0004\u0019A\u0013\t\u000f%2\u0004\u0013!a\u0001U!9aF\u000eI\u0001\u0002\u0004y\u0003b\u0002!\u0001\u0001\u0004%I!Q\u0001\u0007g\u0016\u0014h/\u001a:\u0016\u0003\t\u0003\"aQ%\u000e\u0003\u0011S!\u0001Q#\u000b\u0005\u0019;\u0015!\u00026fiRL(B\u0001%\u0007\u0003\u001d)7\r\\5qg\u0016L!A\u0013#\u0003\rM+'O^3s\u0011\u001da\u0005\u00011A\u0005\n5\u000b!b]3sm\u0016\u0014x\fJ3r)\tq\u0015\u000b\u0005\u0002\u000b\u001f&\u0011\u0001k\u0003\u0002\u0005+:LG\u000fC\u0004S\u0017\u0006\u0005\t\u0019\u0001\"\u0002\u0007a$\u0013\u0007\u0003\u0004U\u0001\u0001\u0006KAQ\u0001\bg\u0016\u0014h/\u001a:!\u0011\u001d1\u0006\u00011A\u0005\n]\u000bA\u0001]8siV\t!\u0006C\u0004Z\u0001\u0001\u0007I\u0011\u0002.\u0002\u0011A|'\u000f^0%KF$\"AT.\t\u000fIC\u0016\u0011!a\u0001U!1Q\f\u0001Q!\n)\nQ\u0001]8si\u0002BQa\u0018\u0001\u0005\u0002\u0001\fQa\u001d;beR$\u0012A\u0014\u0005\u0006E\u0002!IaY\u0001\bI>\u001cF/\u0019:u)\t!w\r\u0005\u0003\u000bK\nS\u0013B\u00014\f\u0005\u0019!V\u000f\u001d7fe!)\u0001.\u0019a\u0001U\u0005I1\u000f^1siB{'\u000f\u001e\u0005\u0006U\u0002!Ia[\u0001\u0015g\u0016$X\u000f]*fGV\u0014\u0018\u000e^=IC:$G.\u001a:\u0015\u00051\u0014\bCA7q\u001b\u0005q'BA8F\u0003!\u0019XmY;sSRL\u0018BA9o\u0005e\u0019uN\\:ue\u0006Lg\u000e^*fGV\u0014\u0018\u000e^=IC:$G.\u001a:\t\u000bML\u0007\u0019A\u0013\u0002\u0017M,7-\u001e:jifluM\u001d\u0005\u0006k\u0002!\t\u0001Y\u0001\u0005gR|\u0007\u000fC\u0003x\u0001\u0011\u0005\u00010A\u0002ve&,\u0012aL\u0004\tu\n\t\t\u0011#\u0001\u0003w\u0006Q\u0001\n\u001e;q'\u0016\u0014h/\u001a:\u0011\u0005Aah\u0001C\u0001\u0003\u0003\u0003E\tAA?\u0014\u0005qL\u0001\"B\u001c}\t\u0003yH#A>\t\u0013\u0005\rA0%A\u0005\u0002\u0005\u0015\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0002\b)\u001a!&!\u0003,\u0005\u0005-\u0001\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0006\f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00033\tyAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"!\b}#\u0003%\t!a\b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\t\tCK\u00020\u0003\u0013\u0001")
public class HttpServer
implements Logging {
    private final SparkConf conf;
    private final File resourceBase;
    private final SecurityManager securityManager;
    private final int requestedPort;
    private final String serverName;
    private Server server;
    private int port;
    private transient Logger org$apache$spark$Logging$$log_;

    public static String $lessinit$greater$default$5() {
        return HttpServer$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return HttpServer$.MODULE$.$lessinit$greater$default$4();
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    private Server server() {
        return this.server;
    }

    private void server_$eq(Server x$1) {
        this.server = x$1;
    }

    private int port() {
        return this.port;
    }

    private void port_$eq(int x$1) {
        this.port = x$1;
    }

    public void start() {
        if (this.server() == null) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting HTTP Server";
                }
            });
            Tuple2 tuple2 = Utils$.MODULE$.startServiceOnPort(this.requestedPort, new $anonfun$1(this), this.conf, this.serverName);
            if (tuple2 != null) {
                Tuple2 tuple22;
                Server actualServer = (Server)tuple2._1();
                int actualPort = tuple2._2$mcI$sp();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)actualServer, (Object)BoxesRunTime.boxToInteger((int)actualPort));
                Server actualServer2 = (Server)tuple23._1();
                int actualPort2 = tuple23._2$mcI$sp();
                this.server_$eq(actualServer2);
                this.port_$eq(actualPort2);
                return;
            }
            throw new MatchError(tuple2);
        }
        throw new ServerStateException("Server is already started");
    }

    public Tuple2<Server, Object> org$apache$spark$HttpServer$$doStart(int startPort) {
        Server server = new Server();
        SocketConnector connector = (SocketConnector)this.securityManager.fileServerSSLOptions().createJettySslContextFactory().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SslSocketConnector apply(SslContextFactory x$2) {
                return new SslSocketConnector(x$2);
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SocketConnector apply() {
                return new SocketConnector();
            }
        });
        connector.setMaxIdleTime(60000);
        connector.setSoLingerTime(-1);
        connector.setPort(startPort);
        server.addConnector(connector);
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setDaemon(true);
        server.setThreadPool(threadPool);
        ResourceHandler resHandler = new ResourceHandler();
        resHandler.setResourceBase(this.resourceBase.getAbsolutePath());
        HandlerList handlerList = new HandlerList();
        handlerList.setHandlers((Handler[])((Object[])new Handler[]{resHandler, new DefaultHandler()}));
        if (this.securityManager.isAuthenticationEnabled()) {
            this.logDebug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "HttpServer is using security";
                }
            });
            ConstraintSecurityHandler sh = this.setupSecurityHandler(this.securityManager);
            sh.setHandler(handlerList);
            server.setHandler(sh);
        } else {
            this.logDebug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "HttpServer is not using security";
                }
            });
            server.setHandler(handlerList);
        }
        server.start();
        int actualPort = server.getConnectors()[0].getLocalPort();
        return new Tuple2((Object)server, (Object)BoxesRunTime.boxToInteger((int)actualPort));
    }

    private ConstraintSecurityHandler setupSecurityHandler(SecurityManager securityMgr) {
        Constraint constraint = new Constraint();
        constraint.setName("DIGEST");
        constraint.setRoles((String[])((Object[])new String[]{"user"}));
        constraint.setAuthenticate(true);
        constraint.setDataConstraint(0);
        ConstraintMapping cm = new ConstraintMapping();
        cm.setConstraint(constraint);
        cm.setPathSpec("/*");
        ConstraintSecurityHandler sh = new ConstraintSecurityHandler();
        HashLoginService hashLogin = new HashLoginService();
        Password userCred = new Password(securityMgr.getSecretKey());
        if (userCred == null) {
            throw new Exception("Error: secret key is null with authentication on");
        }
        hashLogin.putUser(securityMgr.getHttpUser(), userCred, (String[])((Object[])new String[]{"user"}));
        sh.setLoginService(hashLogin);
        sh.setAuthenticator(new DigestAuthenticator());
        sh.setConstraintMappings((ConstraintMapping[])((Object[])new ConstraintMapping[]{cm}));
        return sh;
    }

    public void stop() {
        if (this.server() == null) {
            throw new ServerStateException("Server is already stopped");
        }
        this.server().stop();
        this.port_$eq(-1);
        this.server_$eq(null);
    }

    public String uri() {
        if (this.server() == null) {
            throw new ServerStateException("Server is not started");
        }
        String scheme = this.securityManager.fileServerSSLOptions().enabled() ? "https" : "http";
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scheme, Utils$.MODULE$.localHostNameForURI(), BoxesRunTime.boxToInteger((int)this.port())}));
    }

    public HttpServer(SparkConf conf, File resourceBase, SecurityManager securityManager, int requestedPort, String serverName) {
        this.conf = conf;
        this.resourceBase = resourceBase;
        this.securityManager = securityManager;
        this.requestedPort = requestedPort;
        this.serverName = serverName;
        Logging$class.$init$(this);
        this.server = null;
        this.port = requestedPort;
    }
}

