/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.standalone.subscriber;

import com.google.common.eventbus.Subscribe;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.shardingsphere.infra.executor.sql.process.model.yaml.BatchYamlExecuteProcessContext;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.process.ShowProcessListManager;
import org.apache.shardingsphere.mode.process.event.KillProcessListIdRequestEvent;
import org.apache.shardingsphere.mode.process.event.ShowProcessListRequestEvent;
import org.apache.shardingsphere.mode.process.event.ShowProcessListResponseEvent;

public final class ProcessStandaloneSubscriber {
    private final EventBusContext eventBusContext;

    public ProcessStandaloneSubscriber(EventBusContext eventBusContext) {
        this.eventBusContext = eventBusContext;
        eventBusContext.register((Object)this);
    }

    @Subscribe
    public void loadShowProcessListData(ShowProcessListRequestEvent event) {
        BatchYamlExecuteProcessContext batchYamlExecuteProcessContext = new BatchYamlExecuteProcessContext(new ArrayList(ShowProcessListManager.getInstance().getProcessContexts().values()));
        this.eventBusContext.post((Object)new ShowProcessListResponseEvent(batchYamlExecuteProcessContext.getContexts().isEmpty() ? Collections.emptyList() : Collections.singletonList(YamlEngine.marshal((Object)batchYamlExecuteProcessContext))));
    }

    @Subscribe
    public void killProcessListId(KillProcessListIdRequestEvent event) {
        Collection statements = ShowProcessListManager.getInstance().getProcessStatement(event.getProcessListId());
        for (Statement statement : statements) {
            statement.cancel();
        }
    }
}

