/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.standalone.lock;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.shardingsphere.infra.lock.LockState;

public final class StandaloneExclusiveLock
extends ReentrantLock {
    private final AtomicReference<LockState> lockState = new AtomicReference<LockState>(LockState.UNLOCKED);

    @Override
    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        if (!this.lockState.compareAndSet(LockState.UNLOCKED, LockState.LOCKING)) {
            return false;
        }
        boolean isLocked = super.tryLock(timeout, unit);
        if (isLocked && this.lockState.compareAndSet(LockState.LOCKING, LockState.LOCKED)) {
            return true;
        }
        this.lockState.compareAndSet(LockState.LOCKING, LockState.UNLOCKED);
        return false;
    }

    @Override
    public void unlock() {
        if (LockState.LOCKED == this.lockState.get()) {
            super.unlock();
            this.lockState.compareAndSet(LockState.LOCKED, LockState.UNLOCKED);
        }
    }

    @Override
    public boolean isLocked() {
        return LockState.LOCKED == this.lockState.get();
    }
}

