/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.standalone.lock;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.shardingsphere.infra.lock.ShardingSphereLock;
import org.apache.shardingsphere.mode.manager.standalone.lock.StandaloneExclusiveLock;

public final class ShardingSphereStandaloneLock
implements ShardingSphereLock {
    private final Map<String, ReentrantLock> locks = new ConcurrentHashMap<String, ReentrantLock>();

    public synchronized boolean tryLock(String lockName, long timeoutMillis) {
        Preconditions.checkNotNull((Object)lockName, (Object)"Try lock args lockName name can not be null.");
        ReentrantLock lock = this.locks.get(lockName);
        if (null == lock) {
            lock = new StandaloneExclusiveLock();
            this.locks.put(lockName, lock);
        }
        return this.innerTryLock(lock, timeoutMillis);
    }

    private boolean innerTryLock(ReentrantLock lock, long timeoutMillis) {
        try {
            return lock.tryLock(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ignored) {
            return false;
        }
    }

    public void unlock(String lockName) {
        Preconditions.checkNotNull((Object)lockName, (Object)"Release lock args lockName name can not be null.");
        this.locks.get(lockName).unlock();
    }
}

