/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.standalone;

import java.sql.SQLException;
import org.apache.shardingsphere.infra.config.mode.PersistRepositoryConfiguration;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.instance.workerid.WorkerIdGenerator;
import org.apache.shardingsphere.infra.lock.LockContext;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.mode.lock.LockPersistService;
import org.apache.shardingsphere.mode.lock.ShardingSphereLockContext;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilder;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilderParameter;
import org.apache.shardingsphere.mode.manager.standalone.lock.StandaloneLockPersistService;
import org.apache.shardingsphere.mode.manager.standalone.subscriber.ProcessStandaloneSubscriber;
import org.apache.shardingsphere.mode.manager.standalone.workerid.generator.StandaloneWorkerIdGenerator;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsFactory;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;
import org.apache.shardingsphere.mode.repository.standalone.StandalonePersistRepository;
import org.apache.shardingsphere.mode.repository.standalone.StandalonePersistRepositoryFactory;
import org.apache.shardingsphere.schedule.core.ScheduleContextFactory;

public final class StandaloneContextManagerBuilder
implements ContextManagerBuilder {
    public ContextManager build(ContextManagerBuilderParameter parameter) throws SQLException {
        ScheduleContextFactory.getInstance().init(parameter.getInstanceMetaData().getId(), parameter.getModeConfiguration());
        StandalonePersistRepository repository = StandalonePersistRepositoryFactory.getInstance((PersistRepositoryConfiguration)parameter.getModeConfiguration().getRepository());
        MetaDataPersistService persistService = new MetaDataPersistService((PersistRepository)repository);
        this.persistConfigurations(persistService, parameter);
        InstanceContext instanceContext = this.buildInstanceContext(parameter);
        new ProcessStandaloneSubscriber(instanceContext.getEventBusContext());
        MetaDataContexts metaDataContexts = MetaDataContextsFactory.create((MetaDataPersistService)persistService, (ContextManagerBuilderParameter)parameter, (InstanceContext)instanceContext);
        return new ContextManager(metaDataContexts, instanceContext);
    }

    private void persistConfigurations(MetaDataPersistService persistService, ContextManagerBuilderParameter parameter) {
        if (!parameter.isEmpty()) {
            persistService.persistConfigurations(parameter.getDatabaseConfigs(), parameter.getGlobalRuleConfigs(), parameter.getProps(), parameter.getModeConfiguration().isOverwrite());
        }
    }

    private InstanceContext buildInstanceContext(ContextManagerBuilderParameter parameter) {
        return new InstanceContext(new ComputeNodeInstance(parameter.getInstanceMetaData()), (WorkerIdGenerator)new StandaloneWorkerIdGenerator(), parameter.getModeConfiguration(), (LockContext)new ShardingSphereLockContext((LockPersistService)new StandaloneLockPersistService()), new EventBusContext());
    }

    public String getType() {
        return "Standalone";
    }

    public boolean isDefault() {
        return true;
    }
}

