/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.standalone.lock;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.shardingsphere.infra.lock.LockContext;
import org.apache.shardingsphere.infra.lock.ShardingSphereLock;
import org.apache.shardingsphere.mode.manager.standalone.lock.ShardingSphereNonReentrantLock;

public final class StandaloneLockContext
implements LockContext {
    private final Map<String, ShardingSphereLock> locks = new ConcurrentHashMap<String, ShardingSphereLock>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShardingSphereLock getOrCreateSchemaLock(String schemaName) {
        Preconditions.checkNotNull((Object)schemaName, (Object)"Get or create schema lock args schema name can not be null.");
        ShardingSphereLock result = this.locks.get(schemaName);
        if (null != result) {
            return result;
        }
        Map<String, ShardingSphereLock> map = this.locks;
        synchronized (map) {
            result = this.locks.get(schemaName);
            if (null != result) {
                return result;
            }
            result = new ShardingSphereNonReentrantLock(new ReentrantLock());
            this.locks.put(schemaName, result);
            return result;
        }
    }

    public Optional<ShardingSphereLock> getSchemaLock(String schemaName) {
        if (null == schemaName) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.locks.get(schemaName));
    }

    public boolean isLockedSchema(String schemaName) {
        Preconditions.checkNotNull((Object)schemaName, (Object)"Is locked schema args schema name can not be null.");
        ShardingSphereLock shardingSphereLock = this.locks.get(schemaName);
        return null != shardingSphereLock && shardingSphereLock.isLocked(schemaName);
    }
}

