/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.singletable.rule;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.scope.SchemaRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataSourceContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.ExportableRule;
import org.apache.shardingsphere.infra.rule.identifier.type.MutableDataNodeRule;
import org.apache.shardingsphere.infra.rule.identifier.type.TableContainedRule;
import org.apache.shardingsphere.singletable.config.SingleTableRuleConfiguration;
import org.apache.shardingsphere.singletable.rule.SingleTableDataNodeLoader;

public final class SingleTableRule
implements SchemaRule,
DataNodeContainedRule,
TableContainedRule,
MutableDataNodeRule,
ExportableRule {
    private String defaultDataSource;
    private final Collection<String> dataSourceNames;
    private final Map<String, Collection<DataNode>> singleTableDataNodes;
    private final Map<String, String> tableNames;

    public SingleTableRule(SingleTableRuleConfiguration config, DatabaseType databaseType, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> builtRules, ConfigurationProperties props) {
        Map<String, DataSource> aggregateDataSourceMap = this.getAggregateDataSourceMap(dataSourceMap, builtRules);
        this.dataSourceNames = aggregateDataSourceMap.keySet();
        this.singleTableDataNodes = SingleTableDataNodeLoader.load(databaseType, aggregateDataSourceMap, this.getExcludedTables(builtRules), props);
        this.tableNames = this.singleTableDataNodes.entrySet().stream().collect(Collectors.toConcurrentMap(Map.Entry::getKey, entry -> ((DataNode)((Collection)entry.getValue()).iterator().next()).getTableName()));
        config.getDefaultDataSource().ifPresent(optional -> {
            this.defaultDataSource = optional;
        });
    }

    private Map<String, DataSource> getAggregateDataSourceMap(Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> builtRules) {
        Map<String, DataSource> result = new LinkedHashMap<String, DataSource>(dataSourceMap);
        for (ShardingSphereRule each : builtRules) {
            if (!(each instanceof DataSourceContainedRule)) continue;
            result = this.getAggregateDataSourceMap(result, (DataSourceContainedRule)each);
        }
        return result;
    }

    private Map<String, DataSource> getAggregateDataSourceMap(Map<String, DataSource> dataSourceMap, DataSourceContainedRule builtRule) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>();
        for (Map.Entry entry : builtRule.getDataSourceMapper().entrySet()) {
            for (String each : (Collection)entry.getValue()) {
                if (!dataSourceMap.containsKey(each)) continue;
                result.putIfAbsent((String)entry.getKey(), dataSourceMap.remove(each));
            }
        }
        result.putAll(dataSourceMap);
        return result;
    }

    public boolean isSingleTablesInSameDataSource(Collection<String> singleTableNames) {
        String firstFoundDataSourceName = null;
        for (String each : singleTableNames) {
            Optional<DataNode> dataNode = this.findSingleTableDataNode(each);
            if (!dataNode.isPresent()) continue;
            if (null == firstFoundDataSourceName) {
                firstFoundDataSourceName = dataNode.get().getDataSourceName();
                continue;
            }
            if (firstFoundDataSourceName.equals(dataNode.get().getDataSourceName())) continue;
            return false;
        }
        return true;
    }

    public boolean isAllTablesInSameDataSource(RouteContext routeContext, Collection<String> singleTableNames) {
        if (!this.isSingleTablesInSameDataSource(singleTableNames)) {
            return false;
        }
        Optional<DataNode> dataNode = this.findSingleTableDataNode(singleTableNames.iterator().next());
        if (dataNode.isPresent()) {
            for (RouteUnit each : routeContext.getRouteUnits()) {
                if (each.getDataSourceMapper().getLogicName().equals(dataNode.get().getDataSourceName())) continue;
                return false;
            }
        }
        return true;
    }

    public Optional<String> getDefaultDataSource() {
        return Optional.ofNullable(this.defaultDataSource);
    }

    public Collection<String> getSingleTableNames(Collection<String> tableNames) {
        LinkedList<String> result = new LinkedList<String>();
        for (String each : tableNames) {
            if (!this.singleTableDataNodes.containsKey(each.toLowerCase())) continue;
            result.add(each);
        }
        return result;
    }

    public void put(String tableName, String dataSourceName) {
        if (this.dataSourceNames.contains(dataSourceName)) {
            this.singleTableDataNodes.put(tableName.toLowerCase(), Collections.singletonList(new DataNode(dataSourceName, tableName)));
            this.tableNames.put(tableName.toLowerCase(), tableName);
        }
    }

    public void remove(String tableName) {
        this.singleTableDataNodes.remove(tableName.toLowerCase());
        this.tableNames.remove(tableName.toLowerCase());
    }

    private Collection<String> getExcludedTables(Collection<ShardingSphereRule> rules) {
        return rules.stream().filter(each -> each instanceof DataNodeContainedRule).flatMap(each -> ((DataNodeContainedRule)each).getAllTables().stream()).collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER)));
    }

    public Optional<DataNode> findSingleTableDataNode(String tableName) {
        return Optional.ofNullable(this.singleTableDataNodes.get(tableName.toLowerCase())).map(optional -> (DataNode)optional.iterator().next());
    }

    public Map<String, Collection<DataNode>> getAllDataNodes() {
        return this.singleTableDataNodes;
    }

    public Collection<DataNode> getDataNodesByTableName(String tableName) {
        return this.singleTableDataNodes.getOrDefault(tableName.toLowerCase(), Collections.emptyList());
    }

    public Optional<String> findFirstActualTable(String logicTable) {
        return Optional.empty();
    }

    public boolean isNeedAccumulate(Collection<String> tables) {
        return false;
    }

    public Optional<String> findLogicTableByActualTable(String actualTable) {
        return Optional.empty();
    }

    public Optional<String> findActualTableByCatalog(String catalog, String logicTable) {
        return Optional.empty();
    }

    public Collection<String> getAllTables() {
        return this.tableNames.values();
    }

    public Collection<String> getTables() {
        return this.tableNames.values();
    }

    public String getType() {
        return SingleTableRule.class.getSimpleName();
    }

    public Map<String, Supplier<Object>> getExportedMethods() {
        HashMap<String, Supplier<Object>> result = new HashMap<String, Supplier<Object>>(1, 1.0f);
        result.put("single_tables", this.tableNames::keySet);
        return result;
    }

    @Generated
    public Collection<String> getDataSourceNames() {
        return this.dataSourceNames;
    }

    @Generated
    public Map<String, Collection<DataNode>> getSingleTableDataNodes() {
        return this.singleTableDataNodes;
    }

    @Generated
    public Map<String, String> getTableNames() {
        return this.tableNames;
    }
}

